@extends("web.layout.master")

@push('head')
<link rel="stylesheet" href="{{ asset('css/bootstrap.min.css')}}" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/css/selectize.default.min.css" integrity="sha512-pTaEn+6gF1IeWv3W1+7X7eM60TFu/agjgoHmYhAfLEU8Phuf6JKiiE8YmsNC0aCgQv4192s4Vai8YZ6VNM6vyQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="{{ asset('css/animate.css') }}" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.css" rel="stylesheet" />
<link rel="stylesheet" type="text/css" href="{{ asset('css/style.css') }}" />
<link rel="stylesheet" type="text/css" href="{{ asset('css/media.css') }}" />
<link rel="stylesheet" type="text/css" href="{{ asset('css/toastr.min.css') }}" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css" integrity="sha512-tS3S5qG0BlhnQROyJXvNjeEM4UpMXHrQfTGmbQ1gKmelCxlSEBUaxhRBj/EFTzpbP4RVSrpEikbmdJobCvhE3g==" crossorigin="anonymous" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css" integrity="sha512-sMXtMNL1zRzolHYKEujM2AqCLUR9F2C4/05cdbxjjLSRvMQIciEPCQZo++nk7go3BtSuK9kfa/s+a4f4i5pLkw==" crossorigin="anonymous" />

<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
<link href="https://fonts.cdnfonts.com/css/proxima-nova-condensed" rel="stylesheet">
<link rel="icon" type="image/png" href="{{ asset('images/apple-touch-icon.png') }}" sizes="16x16" />
<link rel="stylesheet" href="https://code.getmdl.io/1.3.0/material.indigo-pink.min.css">
@endpush

@php
$urlParts = explode('/', url()->current());
$lastPart = last($urlParts);
@endphp

@section('section')

<section class="order-tab-section">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <div class="order-mood-label">
                    <h3>What are you in the mood for?</h3>
                </div>
            </div>
            <div class="col-md-8">
                <div class="deal-label">
                    <h2>Starters</h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="nav flex-column nav-pills nav-p-tab" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                    <a class="nav-link {{ $lastPart == $category['6']['slug'] ? 'active' : '' }} " id="v-pills-pizzas-tab" data-toggle="pill" href="{{ route('user.order.index', ['slug' => 'pizza']) }}" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 512.001 512.001" style="enable-background:new 0 0 512 512" xml:space="preserve">
                            <g>
                                <path d="M509.026 2.885A9.995 9.995 0 0 0 498.642.583L83.289 148.68c-14.43-8.824-32.733-10.89-49.52-3.939-27.865 11.543-41.146 43.604-29.604 71.471 27.219 65.708 66.518 124.525 116.809 174.816s109.107 89.591 174.816 116.809a54.41 54.41 0 0 0 20.861 4.164c21.475-.001 41.894-12.726 50.609-33.769 5.864-14.158 5.31-29.396-.299-42.48L511.462 13.238a10.002 10.002 0 0 0-2.436-10.353zM146.179 147.489l44.02-15.694a25.442 25.442 0 0 1 6.678 20.752c-.89 6.75-4.354 12.751-9.755 16.896-5.401 4.145-12.089 5.936-18.844 5.049-6.749-.889-12.749-4.352-16.894-9.754-3.819-4.977-5.636-11.049-5.205-17.249zm202.603 323.088c-7.322 17.678-27.664 26.103-45.338 18.779-128.04-53.035-227.763-152.759-280.8-280.799-3.547-8.563-3.547-17.994 0-26.558 3.547-8.563 10.216-15.232 18.779-18.779s17.995-3.547 26.558 0 15.232 10.216 18.779 18.779c22.701 54.807 55.481 103.865 97.429 145.813 41.948 41.948 91.006 74.727 145.813 97.429 17.678 7.321 26.103 27.66 18.78 45.336zm88.843-303.248a25.786 25.786 0 0 1-2.715-.192c-6.749-.889-12.749-4.353-16.893-9.754-4.145-5.401-5.938-12.094-5.05-18.843 1.835-13.934 14.66-23.776 28.599-21.944 4.3.566 8.337 2.234 11.78 4.771l-15.721 45.962zm22.368-65.406a45.478 45.478 0 0 0-15.817-5.156c-24.871-3.283-47.764 14.294-51.038 39.163-1.586 12.046 1.614 23.989 9.011 33.629 7.125 9.285 17.325 15.351 28.831 17.201l-19.876 58.119-22.858-17.54c-4.381-3.36-10.66-2.536-14.021 1.846-3.362 4.382-2.535 10.659 1.846 14.021l28.205 21.642-51.694 151.155a54.475 54.475 0 0 0-14.922-9.241c-105.98-43.899-188.52-126.439-232.417-232.417a54.66 54.66 0 0 0-5.609-10.26l26.779-9.548c.935 8.068 4.032 15.764 9.105 22.375 7.396 9.64 18.105 15.822 30.151 17.407 2.018.266 4.03.398 6.032.398 9.948 0 19.572-3.25 27.597-9.407 9.641-7.398 15.822-18.105 17.409-30.153a45.412 45.412 0 0 0-6.768-30.401l124.307-44.322 4.711 11.374a10.005 10.005 0 0 0 9.243 6.176 9.98 9.98 0 0 0 3.823-.764c5.102-2.113 7.525-7.964 5.412-13.066l-4.326-10.445 132.719-47.322-25.835 75.536z" opacity="1"></path>
                                <path d="M108 268.276c-.03-.047-.113-.174-.145-.22-3.062-4.593-9.259-5.826-13.854-2.767-4.587 3.054-5.831 9.253-2.795 13.848a9.995 9.995 0 0 0 13.789 2.958c4.646-2.987 5.991-9.174 3.005-13.819zM92.791 243.433a473.307 473.307 0 0 1-26.036-53.147c-2.113-5.104-7.966-7.524-13.065-5.411-5.103 2.113-7.525 7.963-5.411 13.065a493.223 493.223 0 0 0 27.14 55.401 9.997 9.997 0 0 0 13.64 3.733c4.797-2.737 6.469-8.844 3.732-13.641zM312.933 127.987a45.819 45.819 0 0 0-5.983-.394c-22.717 0-42.087 17.005-45.055 39.555-3.274 24.868 14.293 47.764 39.161 51.038 1.982.262 3.995.394 5.983.394 22.716 0 42.086-17.005 45.055-39.557 3.273-24.867-14.294-47.762-39.161-51.036zm19.333 48.426c-1.664 12.637-12.509 22.166-25.227 22.166-1.118 0-2.253-.074-3.372-.222-13.935-1.835-23.777-14.664-21.943-28.599 1.664-12.636 12.508-22.164 25.226-22.164 1.118 0 2.253.074 3.372.222 13.934 1.836 23.778 14.664 21.944 28.597zM310.331 252.374a45.83 45.83 0 0 0-5.983-.394c-22.717 0-42.087 17.005-45.055 39.556-1.587 12.047 1.613 23.989 9.01 33.63 7.396 9.64 18.104 15.822 30.151 17.409 1.981.261 3.993.392 5.98.392 22.717 0 42.088-17.005 45.057-39.557 3.275-24.866-14.293-47.76-39.16-51.036zm19.333 48.427c-1.664 12.637-12.51 22.166-25.228 22.166a25.96 25.96 0 0 1-3.37-.222c-6.75-.89-12.75-4.354-16.895-9.755-4.145-5.401-5.938-12.093-5.049-18.844 1.664-12.636 12.509-22.165 25.226-22.165 1.118 0 2.253.074 3.372.222 13.933 1.835 23.777 14.664 21.944 28.598zM244.375 210.946l-30.736-4.047c-5.473-.727-10.499 3.133-11.22 8.608-.722 5.476 3.133 10.499 8.608 11.22l30.736 4.047c.443.059.883.087 1.318.087 4.941 0 9.239-3.663 9.901-8.695.723-5.475-3.131-10.499-8.607-11.22zM228.79 284.743l-2.714-20.624c-.721-5.476-5.743-9.332-11.219-8.609-5.476.721-9.33 5.743-8.609 11.219l2.715 20.624c.662 5.033 4.959 8.696 9.901 8.696.435 0 .875-.028 1.317-.087 5.476-.721 9.33-5.743 8.609-11.219z" opacity="1"></path>
                            </g>
                        </svg>
                        Pizzas
                    </a>
                    <a class="nav-link {{ $lastPart == $category['2']['slug'] ? 'active' : '' }} " id="v-pills-Pastas-tab" data-toggle="pill" href="{{ route('user.order.index', ['slug' => 'pasta']) }}" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 511.998 511.998" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                            <g>
                                <path d="M494.933 274.138h-30.566a243.28 243.28 0 0 1-26.607-37.376c-12.544-21.606-24.397-42.027-44.732-52.907-27.307-14.763-57.967-8.141-71.373-9.079a107.427 107.427 0 0 1-12.092-10.633c-2.79-2.688-5.026-5.163-7.151-7.509a76.083 76.083 0 0 0-26.786-20.429 42.548 42.548 0 0 0 5.47-4.489c28.459-28.45 21.606-71.808 21.333-73.643a8.532 8.532 0 0 0-7.014-7.014c-1.843-.299-45.227-7.151-73.651 21.333a42.2 42.2 0 0 0-3.746 4.574 43.507 43.507 0 0 0-3.755-4.574c-28.45-28.45-71.808-21.598-73.651-21.333a8.532 8.532 0 0 0-7.014 7.023c-.307 1.826-7.142 45.227 21.333 73.634a42.387 42.387 0 0 0 7.458 5.828h-.068a99.883 99.883 0 0 0-17.263 12.314 129.858 129.858 0 0 0-27.469 35.934c-20.907 7.782-62.123 25.813-76.305 88.346H17.067a17.067 17.067 0 0 0-16.733 20.42l4.659 23.253c16.92 83.662 90.363 143.873 175.718 144.06H331.29c85.355-.187 158.798-60.398 175.718-144.06l4.659-23.262a17.067 17.067 0 0 0-16.734-20.411zm-198.084-98.56a72.036 72.036 0 0 0 19.866 15.633c11.819 3.362 43.008-5.973 68.207 7.68 16.094 8.602 26.76 26.982 38.298 46.857a287.094 287.094 0 0 0 19.021 28.39h-21.734c-4.139-6.34-8.175-13.133-12.066-19.84-10.12-17.493-19.686-34.022-31.573-40.414a76.591 76.591 0 0 0-40.26-5.274 74.237 74.237 0 0 1-26.556-1.707 78.795 78.795 0 0 1-24.243-18.27 513.69 513.69 0 0 0-4.838-4.608 27.606 27.606 0 0 1 12.843-7.851c1.115-.238 2.003-.383 3.035-.596zM186.88 237.069a205.132 205.132 0 0 0 3.499-6.468c1.587-3.021 3.14-5.922 4.77-8.602a278.26 278.26 0 0 1 25.865 22.613 340.58 340.58 0 0 0 34.364 29.525H228.07c-6.511-5.649-12.8-11.52-18.773-17.161l-.64-.589c-8.883-8.361-16.119-15-21.777-19.318zm15.812 37.069h-69.973a49.328 49.328 0 0 1 19.379-10.01 72.4 72.4 0 0 0 22.963-11.503c.64-.546 1.169-1.212 1.766-1.801 5.606 4.335 14.14 12.305 20.258 18.022l.589.555c1.596 1.545 3.337 3.158 5.018 4.737zm30.046-41.95c-8.533-8.055-16.768-15.778-24.542-21.751a68.33 68.33 0 0 1 18.842-.853c1.707.077 3.362.128 5.043.179a59.474 59.474 0 0 1 16.137 13.295 128.135 128.135 0 0 0 43.989 31.829c34.628 12.8 52.326-4.975 65.271 14.438.853 1.519 1.801 3.183 2.705 4.787h-44.911a100.395 100.395 0 0 1-34.987-5.12c-15.385-6.502-32.468-22.605-47.547-36.804zm65.425 6.733a114.453 114.453 0 0 1-37.948-27.981 437.386 437.386 0 0 0-4.599-4.497 44.737 44.737 0 0 0 13.73-9.89 479.938 479.938 0 0 1 4.599 4.378 92.272 92.272 0 0 0 30.114 22.007 85.92 85.92 0 0 0 33.28 2.748 65.305 65.305 0 0 1 31.428 3.26c7.62 4.105 16.401 19.26 24.892 33.929a883.33 883.33 0 0 0 6.63 11.29h-20.113c-2.901-4.446-5.521-8.969-8.073-13.594-16.8-30.482-42.187-9.917-73.94-21.65zm-14.549-77.184a58.913 58.913 0 0 0-21.41 17.408l-.051.06-.085.068v.06c-10.982 12.587-13.747 14.106-34.261 13.227-29.517-1.34-38.528 3.533-52.506 30.106a58.943 58.943 0 0 1-11.332 16.99 59.857 59.857 0 0 1-17.664 8.422c-12.092 4.369-27.981 10.197-32.614 26.061H95.002c8.533-28.74 28.791-36.147 45.38-42.129a78.911 78.911 0 0 0 11.093-4.463 8.527 8.527 0 0 0 2.697-2.398 98.083 98.083 0 0 0 5.973-10.479 87.295 87.295 0 0 1 18.773-26.394 44.649 44.649 0 0 1 8.303-6.025 74.14 74.14 0 0 1 41.122-6.775 27.513 27.513 0 0 0 16.435-1.886c4.855-3.669 14.507-15.113 23.646-21.922a56.534 56.534 0 0 1 15.19 10.069zm-49.801-77.304a68.137 68.137 0 0 1 48.094-17.203c1.545 0 2.97 0 4.267.102a70.51 70.51 0 0 1-17.067 52.318c-9.859 9.396-25.358 9.396-35.217 0-9.733-9.709-9.767-25.465-.077-35.217zm-83.968-17.067a70.397 70.397 0 0 1 52.326 17.067c9.703 9.734 9.703 25.483 0 35.217-9.862 9.397-25.364 9.397-35.226 0a70.55 70.55 0 0 1-17.135-52.318zm-23.441 133.385a8.592 8.592 0 0 0 4.591-3.968 116.493 116.493 0 0 1 25.293-34.133 81.157 81.157 0 0 1 14.293-10.24 110.187 110.187 0 0 1 78.66-6.903c-3.729 3.516-11.597 11.537-13.312 13.141-2.048 0-4.625-.145-6.912-.282a90.452 90.452 0 0 0-50.125 8.934 61.379 61.379 0 0 0-11.375 8.218 103.243 103.243 0 0 0-22.562 31.343c-1.169 2.347-2.56 4.838-3.507 6.519-2.133.853-5.427 2.022-6.767 2.5-17.98 6.468-47.403 17.143-57.344 58.197H58.752c7.24-35.079 33.267-63.29 67.652-73.326zm363.87 113.715c-15.307 75.695-81.758 130.172-158.985 130.338H180.71c-77.227-.166-143.677-54.643-158.985-130.338l-4.659-23.262H494.933z" opacity="1"></path>
                                <path fill-rule="evenodd" d="M180.71 410.671c-58.369.001-109.346-39.485-123.938-96a8.534 8.534 0 1 0-16.512 4.267c16.537 64.046 74.304 108.795 140.45 108.8 4.713 0 8.533-3.82 8.533-8.533s-3.82-8.534-8.533-8.534z" clip-rule="evenodd" opacity="1"></path>
                            </g>
                        </svg>
                        Pastas
                    </a>
                    <a class="nav-link {{ $lastPart == $category['4']['slug'] ? 'active' : '' }} " id="v-pills-Starters-tab" data-toggle="pill" href="#v-pills-Starters" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                            <g>
                                <path d="M496.55 244.672h-79.16a28.5 28.5 0 0 0 3.505-13.719v-40.168c0-13.62-9.551-25.043-22.31-27.95a31.539 31.539 0 0 0 5.282-17.495 31.54 31.54 0 0 0-4.816-16.778h12.078c9.133 0 16.562-7.43 16.562-16.562V91.703c0-9.133-7.43-16.562-16.562-16.562h-31.516V7.477c0-4.133-3.343-7.477-7.472-7.477s-7.477 3.344-7.477 7.477V75.14h-31.512c-9.132 0-16.562 7.43-16.562 16.562V112c0 9.133 7.43 16.563 16.562 16.563h12.078a31.54 31.54 0 0 0-4.816 16.777c0 6.46 1.95 12.476 5.281 17.496-12.757 2.906-22.308 14.328-22.308 27.95v40.167c0 4.965 1.273 9.64 3.504 13.719h-24.66a49.482 49.482 0 0 0 2.699-16.168c0-19.195-10.973-35.863-26.97-44.09 5.645-5.73 9.134-13.59 9.134-22.25 0-14.918-10.352-27.457-24.25-30.828V62.773a7.471 7.471 0 0 0-7.477-7.472 7.473 7.473 0 0 0-7.472 7.472v68.563c-13.899 3.371-24.25 15.91-24.25 30.828 0 8.66 3.488 16.52 9.132 22.25-15.996 8.23-26.968 24.899-26.968 44.09 0 5.559.918 11.012 2.699 16.168H192.57c.055-.531.082-1.067.082-1.61v-20.3c0-.953-.097-1.887-.254-2.797 6.11-2.442 10.442-8.406 10.442-15.375v-9.336c0-9.133-7.43-16.563-16.563-16.563h-3.925a28.472 28.472 0 0 0 3.503-13.722v-40.164c0-15.809-12.859-28.672-28.667-28.672h-12.61V28.469a7.476 7.476 0 0 0-7.473-7.477 7.477 7.477 0 0 0-7.476 7.477v67.668h-12.61c-15.808 0-28.667 12.86-28.667 28.668v4.98a7.473 7.473 0 0 0 7.472 7.473 7.474 7.474 0 0 0 7.477-7.473v-4.98c0-7.567 6.156-13.72 13.719-13.72h40.168c7.562 0 13.718 6.153 13.718 13.72v40.168c0 7.562-6.156 13.718-13.719 13.718H117.02c-7.563 0-13.72-6.156-13.72-13.718a7.477 7.477 0 0 0-7.476-7.477 7.476 7.476 0 0 0-7.472 7.477c0 4.964 1.27 9.64 3.503 13.718H87.93c-9.133 0-16.563 7.43-16.563 16.563v9.336c0 6.969 4.332 12.933 10.442 15.375-.157.91-.254 1.844-.254 2.797v20.3c0 .543.027 1.083.082 1.614H15.449C6.93 244.676 0 251.606 0 260.12v20.734c0 8.52 6.93 15.45 15.45 15.45h29.765v18.875c0 27.242 22.164 49.406 49.406 49.406h321.492c27.246 0 49.41-22.164 49.41-49.406v-18.875h31.028c8.52 0 15.449-6.93 15.449-15.45v-20.734c0-8.52-6.93-15.45-15.45-15.45zM331.54 112V91.703c0-.89.722-1.613 1.612-1.613h77.977c.89 0 1.613.726 1.613 1.613V112c0 .89-.726 1.613-1.613 1.613h-77.977c-.89 0-1.613-.722-1.613-1.613zm57.378 33.34c0 9.25-7.527 16.777-16.777 16.777s-16.778-7.527-16.778-16.777 7.528-16.778 16.778-16.778 16.777 7.528 16.777 16.778zm-50.582 85.613v-40.168c0-7.566 6.156-13.719 13.723-13.719h40.164c7.566 0 13.722 6.153 13.722 13.72v40.167c0 7.567-6.156 13.719-13.722 13.719h-40.164c-7.567 0-13.723-6.152-13.723-13.719zm-99.746-68.789c0-9.25 7.527-16.773 16.777-16.773s16.778 7.523 16.778 16.773c0 9.254-7.528 16.777-16.778 16.777s-16.777-7.523-16.777-16.777zm-17.832 66.34c0-19.086 15.527-34.613 34.61-34.613 19.085 0 34.612 15.527 34.612 34.613a34.44 34.44 0 0 1-4.027 16.168h-61.172a34.413 34.413 0 0 1-4.023-16.168zm-134.446-33.25c0-.89.727-1.613 1.614-1.613h98.347c.891 0 1.614.722 1.614 1.613v9.336c0 .887-.723 1.61-1.614 1.61H87.926c-.887 0-1.61-.723-1.61-1.61v-9.336zM96.5 243.063v-20.301c0-.887.723-1.61 1.613-1.61h77.977c.89 0 1.613.723 1.613 1.61v20.3c0 .887-.723 1.61-1.613 1.61H98.113c-.89 0-1.613-.723-1.613-1.61zm400.55 37.792a.498.498 0 0 1-.5.497H380.978c-4.13 0-7.477 3.347-7.477 7.476s3.348 7.473 7.477 7.473h69.597v18.879c0 18.996-15.46 34.457-34.46 34.457H94.62c-19 0-34.457-15.461-34.457-34.457V296.3h284.734c4.13 0 7.477-3.343 7.477-7.472s-3.348-7.476-7.477-7.476H15.45a.498.498 0 0 1-.5-.497v-20.734c0-.273.223-.5.5-.5h481.106a.5.5 0 0 1 .496.5zm0 0" opacity="1" class=""></path>
                            </g>
                        </svg>
                        Starters
                    </a>
                    <a class="nav-link {{ $lastPart == $category['0']['slug'] ? 'active' : '' }} " id="v-pills-Sandwiches-tab" data-toggle="pill" href="#v-pills-Sandwiches" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                            <g>
                                <path d="M294.672 63.957c32.84 5.086 63.3 16.64 88.09 33.41 23.972 16.219 41.597 36.54 50.972 58.77a9.997 9.997 0 0 0 9.22 6.12 9.973 9.973 0 0 0 3.882-.788c5.09-2.149 7.473-8.012 5.328-13.102-10.883-25.808-31.008-49.172-58.195-67.566-27.219-18.414-60.496-31.074-96.239-36.61-5.449-.843-10.566 2.895-11.41 8.356-.847 5.453 2.89 10.562 8.352 11.41zM100.352 138.973c1.582 3.797 5.609 6.355 9.718 6.16 4.059-.196 7.785-3.067 9.02-6.938 1.25-3.918-.149-8.492-3.43-10.988-3.394-2.578-8.383-2.672-11.867-.21-3.707 2.616-5.156 7.792-3.441 11.976zM148.531 101.734c1.598 3.84 5.696 6.426 9.856 6.16 4.011-.261 7.66-3.12 8.89-6.945 1.254-3.89-.152-8.422-3.379-10.93-3.41-2.644-8.484-2.753-11.984-.218-3.64 2.636-5.117 7.773-3.383 11.933zM200.29 138.973c1.581 3.797 5.612 6.355 9.722 6.16 4.058-.196 7.793-3.067 9.027-6.938 1.25-3.922-.156-8.496-3.441-10.988-3.395-2.578-8.38-2.672-11.868-.21-3.703 2.616-5.156 7.792-3.44 11.976zm0 0" opacity="1" data-original="#000000" class=""></path>
                                <path d="M512 316.938c0-22.02-14.148-40.786-33.824-47.72v-25.023a42.946 42.946 0 0 0 9.074-4.629c11.387-7.652 17.918-19.73 17.918-33.148 0-8.39-2.594-16.332-7.414-23.012a32.269 32.269 0 0 0 1.988-18.511c-8.562-45.797-37.969-87.72-82.8-118.051C372.288 16.637 315.131 0 256 0S139.71 16.637 95.059 46.844c-44.832 30.328-74.239 72.254-82.801 118.05a32.247 32.247 0 0 0 4.176 22.774c-3.114 5.71-4.735 12.07-4.735 18.75 0 13.418 6.531 25.504 17.922 33.152 1.36.914 2.77 1.73 4.203 2.477v27.172C14.148 276.152 0 294.918 0 316.938v2.03c0 14.587 6.215 27.743 16.125 36.985a39.225 39.225 0 0 0-4.426 18.121c0 10.012 3.64 19.274 10.215 26.512v36.086c0 38.55 31.363 69.918 69.918 69.918h328.336c38.555 0 69.918-31.367 69.918-69.918v-31.55c9.621-7.669 15.082-18.798 15.082-31.052 0-7.683-2.164-14.957-6.207-21.246C507.059 343.855 512 331.98 512 318.97zm-20 0v2.03c0 10.325-5.148 19.466-13.008 25.009a30.65 30.65 0 0 1-17.578 5.578H306.348l63.77-63.203h91.292c16.867 0 30.59 13.722 30.59 30.586zm-340.434-30.586 1.586 1.59 10.258 10.253-21.473 21.477-33.32-33.32zm94.418 66.132-61.351-61.347c0-.004-.004-.008-.008-.012l-4.773-4.773h161.812l-66.832 66.093c-.004.004-.008.008-.012.016l-.027.023-14.406 14.407zM31.914 168.566c7.574-40.5 33.98-77.847 74.352-105.16C147.645 35.414 200.82 20 256 20s108.355 15.414 149.734 43.406c40.371 27.313 66.774 64.66 74.352 105.16 1.402 7.512-4.598 14.688-12.223 14.688H44.137c-7.637 0-13.625-7.176-12.223-14.688zm.523 32.512a32.564 32.564 0 0 0 11.7 2.176h423.726c5.52 0 11.07-1.43 15.883-4.137a19.387 19.387 0 0 1 1.422 7.297c0 6.645-3.305 12.676-9.07 16.547-5.895 3.96-13.403 4.91-20.145 2.777-3.332-1.054-6.476-2.414-9.914-3.148-3.719-.797-7.523-1.149-11.324-1.149-17.863 0-27.45 6.766-35.149 12.2-6.757 4.773-12.093 8.543-23.609 8.543s-16.852-3.77-23.61-8.54c-7.699-5.44-17.28-12.203-35.148-12.203-17.863 0-27.445 6.766-35.144 12.204-6.758 4.77-12.094 8.539-23.61 8.539-11.515 0-16.855-3.77-23.613-8.543-7.7-5.438-17.281-12.2-35.144-12.2s-27.45 6.766-35.149 12.2c-6.758 4.773-12.098 8.543-23.61 8.543-11.519 0-16.855-3.77-23.616-8.543-7.7-5.438-17.282-12.2-35.149-12.2-7.066 0-13.437 1.2-19.48 3.664-7.137 2.915-15.489 2.176-21.91-2.14-5.766-3.871-9.07-9.903-9.07-16.547-.005-1.84.245-3.629.734-5.34zm23.375 45.738c5.247-.254 10.168-1.578 15.051-3.437 4.871-1.86 10.184-2.227 15.344-1.766 8.828.785 13.656 4.196 19.57 8.367 7.7 5.438 17.282 12.204 35.149 12.204 17.863 0 27.445-6.766 35.144-12.204 6.758-4.77 12.098-8.539 23.614-8.539s16.851 3.77 23.609 8.54c7.7 5.437 17.285 12.203 35.148 12.203 17.864 0 27.446-6.766 35.145-12.204 6.758-4.77 12.098-8.539 23.61-8.539 11.515 0 16.855 3.77 23.613 8.54 7.699 5.437 17.28 12.203 35.144 12.203s27.445-6.766 35.145-12.204c6.761-4.77 12.097-8.539 23.613-8.539 4.086 0 8.098.68 11.906 2.176 3.715 1.461 7.582 2.512 11.555 2.977v19.761H53.824v-19.484a48.252 48.252 0 0 0 1.989-.055zM20 316.937c0-16.863 13.723-30.585 30.586-30.585h29.75l54.531 54.535c1.875 1.875 4.418 2.925 7.07 2.925s5.196-1.05 7.07-2.925l28.548-28.547 37.215 37.215H50.586a30.604 30.604 0 0 1-15.125-4.02C26.234 340.265 20 330.335 20 318.97zm13.352 49.59a50.736 50.736 0 0 0 17.234 3.028H234.77l18.546 18.547c3.836 3.84 10.262 3.847 14.11.03l18.746-18.577H461.41c5.64 0 11.274-.957 16.602-2.801 1.117-.387 2.258-.777 3.308-1.317.34-.175.832-.566 1.235-.539.554.04.699.747.898 1.192 1.082 2.387 1.66 5 1.707 7.62.168 9.435-6.625 17.33-15.496 19.9-5.082 1.476-10.586 1.148-15.484-.852-6.032-2.465-12.403-3.664-19.47-3.664-17.862 0-27.444 6.765-35.144 12.203-6.761 4.773-12.097 8.543-23.613 8.543-11.512 0-16.851-3.77-23.61-8.543-7.698-5.438-17.28-12.203-35.144-12.203s-27.445 6.765-35.148 12.203c-6.758 4.773-12.094 8.543-23.61 8.543s-16.851-3.77-23.613-8.543c-7.7-5.438-17.281-12.203-35.144-12.203-17.864 0-27.446 6.765-35.149 12.203-6.758 4.773-12.094 8.543-23.61 8.543-11.519 0-16.855-3.774-23.613-8.543-7.703-5.438-17.285-12.203-35.152-12.203-7.066 0-13.437 1.199-19.476 3.668-6.528 2.664-14.137 2.312-20.297-1.157-5.45-3.066-9.508-8.324-10.461-14.57a19.733 19.733 0 0 1-.055-5.594c.07-.539.988-5.093 1.48-4.914zm436.734 70.145c0 27.523-22.395 49.918-49.918 49.918H91.832c-27.523 0-49.918-22.395-49.918-49.918v-23.719c8.211 2.328 17.074 2.164 25.52-.644a45.21 45.21 0 0 0 2.809-1.031c3.593-1.47 7.491-2.18 11.917-2.18 11.52 0 16.856 3.765 23.613 8.539 7.704 5.437 17.286 12.203 35.153 12.203 17.863 0 27.445-6.766 35.144-12.203 6.758-4.774 12.098-8.54 23.61-8.54 11.515 0 16.855 3.766 23.613 8.54 7.7 5.437 17.281 12.203 35.148 12.203 17.864 0 27.446-6.766 35.145-12.203 6.758-4.774 12.098-8.54 23.61-8.54 11.515 0 16.855 3.766 23.609 8.54 7.699 5.437 17.285 12.203 35.148 12.203s27.445-6.766 35.145-12.203c6.757-4.774 12.097-8.54 23.613-8.54 2.98 0 5.969.333 8.848 1.133 2.738.762 5.324 1.965 8.062 2.739 5.945 1.676 12.363 2.031 18.461 1.039v22.664zm0 0" opacity="1" data-original="#000000" class=""></path>
                                <path d="M225.91 101.734c1.582 3.797 5.613 6.375 9.727 6.164 4.058-.207 7.781-3.066 9.02-6.933 1.257-3.922-.153-8.488-3.43-10.992-3.387-2.59-8.383-2.688-11.864-.215-3.691 2.617-5.199 7.793-3.453 11.976zM271.02 145.813c1.582 3.8 5.609 6.355 9.718 6.16 4.063-.196 7.778-3.07 9.024-6.934 1.261-3.918-.153-8.496-3.434-10.992-3.394-2.582-8.383-2.668-11.867-.211-3.703 2.617-5.156 7.793-3.441 11.976zM245.488 56.023c3.559 2.372 8.563 2.137 11.871-.574 3.235-2.648 4.528-7.34 3.036-11.254-1.454-3.8-5.305-6.507-9.387-6.488-4.04.023-7.88 2.676-9.309 6.457-1.597 4.234.035 9.336 3.79 11.86zm0 0" opacity="1"></path>
                            </g>
                        </svg>
                        Sandwiches
                    </a>
                    <a class="nav-link  " id="v-pills-Platters-tab" data-toggle="pill" href="#v-pills-Platters" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                            <g>
                                <path d="M329.171 288.997c-9.268-4.395-20.316-3.553-28.831 2.196a6.001 6.001 0 0 0-2.617 5.52c.937 10.231 7.277 19.317 16.546 23.713a29.082 29.082 0 0 0 12.46 2.791c5.748 0 11.478-1.684 16.37-4.987a6.003 6.003 0 0 0 2.617-5.52c-.936-10.23-7.276-19.317-16.546-23.713zm-9.76 20.585c-4.29-2.033-7.514-5.777-8.963-10.216 4.355-1.687 9.293-1.56 13.583.475 4.29 2.034 7.514 5.778 8.963 10.216-4.354 1.687-9.292 1.56-13.582-.475zM402.097 248.889c-9.925 0-18 8.075-18 18s8.075 18 18 18 18-8.075 18-18-8.075-18-18-18zm0 24c-3.309 0-6-2.691-6-6s2.691-6 6-6 6 2.691 6 6-2.691 6-6 6zM258.097 242.889c-9.925 0-18 8.075-18 18s8.075 18 18 18 18-8.075 18-18-8.075-18-18-18zm0 24c-3.309 0-6-2.691-6-6s2.691-6 6-6 6 2.691 6 6-2.691 6-6 6z" opacity="1"></path>
                                <circle cx="247.097" cy="311.889" r="6" opacity="1"></circle>
                                <circle cx="246.097" cy="218.889" r="6" opacity="1"></circle>
                                <circle cx="328.097" cy="260.889" r="6" opacity="1"></circle>
                                <circle cx="132.097" cy="266.889" r="6" opacity="1"></circle>
                                <path d="M258.448 76.25h30.077c7.891 0 14.311 6.42 14.311 14.311s-6.419 14.311-14.311 14.311h-30.559a6 6 0 0 0 0 12h30.559c14.508 0 26.311-11.803 26.311-26.311S303.033 64.25 288.525 64.25h-30.077c-7.746 0-14.047-6.302-14.047-14.047s6.301-14.047 14.047-14.047h22.214a6 6 0 0 0 5.999-5.87l.435-20.046a6.001 6.001 0 0 0-5.869-6.129 5.998 5.998 0 0 0-6.128 5.869l-.308 14.176h-16.342c-14.362 0-26.047 11.685-26.047 26.047s11.685 26.047 26.047 26.047z" opacity="1"></path>
                                <circle cx="406.509" cy="167.316" r="6" opacity="1"></circle>
                                <path d="M431.042 172.425a6 6 0 1 0-5.769 10.522c36.643 20.09 56.823 45.994 56.823 72.942 0 27.984-21.529 54.611-60.623 74.975-40.334 21.011-94.095 32.582-151.377 32.582s-111.042-11.571-151.377-32.582c-39.093-20.363-60.623-46.99-60.623-74.975 0-22.046 13.279-43.189 38.464-61.387l7.907 9.125c-22.219 15.894-34.371 34.279-34.371 52.262 0 23.721 20.938 47.788 57.445 66.03 38.104 19.04 88.73 29.526 142.555 29.526s104.451-10.486 142.555-29.526c36.507-18.242 57.445-42.31 57.445-66.03 0-26.22-25.856-52.926-69.186-71.448-37.509-15.875-81.516-23.986-130.814-24.108-42.971 0-83.696 6.619-118.137 19.132l-8.357-9.644c36.475-13.888 81.014-21.488 126.494-21.488 39.691 0 78.438 5.681 112.049 16.427 3.157 1.01 6.533-.731 7.542-3.888a6 6 0 0 0-3.888-7.542c-34.778-11.12-74.787-16.997-115.703-16.997-49.323 0-95.808 8.263-134.818 23.882l-54.843-63.29c-10.282-11.865-26.85-15.597-41.226-9.287-10.469 4.596-17.915 13.628-20.428 24.782s.34 22.507 7.828 31.147l4.769 5.504a73.99 73.99 0 0 0 33.027 21.904 61.968 61.968 0 0 1 24.078 14.556c-28.114 20.706-42.694 45.019-42.387 71.358 0 59.833 23.3 116.084 65.608 158.392 22.214 22.214 48.275 39.178 76.677 50.291 10.612 25.426 35.772 42.318 63.498 42.318h36.435c27.726 0 52.885-16.892 63.498-42.318 28.402-11.113 54.463-28.077 76.677-50.291 42.308-42.308 65.608-98.559 65.608-158.392.362-32.216-21.992-61.871-63.055-84.464zm-318.68 40.313 8.994 10.38c-17.014 9.292-30.417 20.08-39.226 31.474.651-13.679 11.524-28.688 30.232-41.854zm77.579 110.059c-.592 1.166-1.204 2.37-1.738 3.66-.527 1.27-.951 2.523-1.36 3.74-17.404-4.111-33.578-9.544-48.032-16.189.395-.961.909-1.979 1.441-3.026.592-1.165 1.204-2.369 1.739-3.66.547-1.32.982-2.625 1.402-3.886.777-2.334 1.512-4.539 2.611-5.638s3.303-1.834 5.636-2.611c1.262-.42 2.567-.854 3.889-1.403 1.29-.534 2.495-1.146 3.66-1.738 2.183-1.108 4.244-2.155 5.908-2.155s3.725 1.047 5.908 2.155c1.165.592 2.37 1.204 3.66 1.738 1.321.548 2.625.982 3.887 1.403 2.333.777 4.537 1.512 5.637 2.612 1.099 1.099 1.833 3.303 2.611 5.636.42 1.262.855 2.567 1.403 3.889.535 1.289 1.147 2.494 1.738 3.658 1.108 2.183 2.156 4.244 2.156 5.908s-1.047 3.726-2.155 5.907zm217.346-11.611c-36.471 18.225-85.192 28.261-137.191 28.261-24.895 0-49.034-2.306-71.442-6.704.552-1.646 1.144-2.877 1.985-4.511 1.54-3.032 3.456-6.806 3.456-11.342s-1.917-8.311-3.457-11.343c-1.105-2.091-1.74-3.66-2.456-5.905-1.129-3.387-2.408-7.226-5.51-10.328-3.103-3.104-6.942-4.383-10.329-5.512-1.11-.37-2.159-.72-3.084-1.104-.864-.357-1.815-.841-2.823-1.353-3.032-1.54-6.805-3.456-11.341-3.456s-8.31 1.917-11.342 3.456c-1.007.512-1.958.995-2.822 1.354-.925.384-1.974.732-3.085 1.103-3.386 1.129-7.225 2.407-10.329 5.511-3.103 3.104-4.382 6.942-5.51 10.33-.956 3.308-2.518 5.851-3.956 9.021-20.886-11.229-35.592-24.533-42.133-37.754 6.753-13.688 22.005-27.187 43.491-38.496l18.285 21.101a6 6 0 0 0 3.857 2.032c9.137 1.039 18.909 1.565 29.044 1.565 8.696 0 24.265-1.158 24.923-1.207a6 6 0 0 0 4.087-9.913l-28.542-32.938c27.26-7.008 57.817-10.703 89.031-10.703 11.511 0 22.97.504 34.184 1.483-.798 2.474-1.491 4.419-2.727 6.713-1.54 3.032-3.457 6.806-3.457 11.343s1.917 8.311 3.457 11.343c.511 1.007.994 1.958 1.353 2.821.386.931.737 1.984 1.12 3.132a6 6 0 0 0 4.995 4.062c9.318 1.09 19.1 1.643 29.076 1.643 9.208 0 18.272-.472 26.941-1.401a6.003 6.003 0 0 0 5.052-4.067c.741-2.326 1.402-4.027 2.551-6.189 1.54-3.032 3.456-6.806 3.456-11.342 0-1.437-.206-2.788-.518-4.072 39.15 12.71 68.493 32.403 78.697 53.087-7.037 14.226-23.518 28.552-46.988 40.281zm-43.191-89.296c0 1.664-1.047 3.726-2.155 5.908-.592 1.165-1.204 2.369-1.738 3.658-.065.157-.128.313-.19.47-7.1.64-14.455.964-21.916.964-8.201 0-16.254-.391-23.995-1.162l-.11-.271c-.535-1.29-1.147-2.494-1.739-3.659-1.108-2.183-2.156-4.244-2.156-5.908s1.047-3.726 2.156-5.908c.592-1.165 1.204-2.369 1.739-3.66.547-1.32.982-2.625 1.402-3.886.751-2.255 1.466-4.38 2.504-5.513.02-.02.042-.037.062-.058.034-.036.064-.075.097-.112 1.115-1.074 3.284-1.8 5.584-2.567 1.262-.42 2.567-.854 3.889-1.403 1.29-.534 2.495-1.146 3.66-1.738 2.183-1.108 4.244-2.155 5.908-2.155s3.725 1.047 5.908 2.155c1.165.592 2.37 1.204 3.66 1.738 1.321.548 2.625.982 3.887 1.403 2.333.777 4.537 1.512 5.637 2.612 1.099 1.099 1.833 3.303 2.611 5.636.42 1.262.855 2.567 1.403 3.889.535 1.289 1.147 2.494 1.738 3.658 1.108 2.183 2.156 4.244 2.156 5.908zm-94.015-49.557c47.677.118 90.121 7.91 126.132 23.15 37.353 15.968 60.844 38.473 61.835 59.055-16.221-21.042-47.736-39.439-88.244-51.023-1.053-3.092-2.368-6.438-5.131-9.202-3.103-3.104-6.942-4.383-10.329-5.512-1.11-.37-2.159-.72-3.084-1.104-.864-.357-1.815-.841-2.823-1.353-3.032-1.54-6.805-3.456-11.341-3.456s-8.31 1.916-11.342 3.456c-2.092 1.105-3.661 1.74-5.907 2.456-2.627.876-5.522 1.853-8.139 3.691a402.613 402.613 0 0 0-41.612-2.142c-34.918 0-67.782 4.252-97.769 12.619L160.4 189.203c32.205-11.046 69.909-16.872 109.682-16.872zm-229.635-31.12-4.768-5.504c-4.965-5.729-6.856-13.256-5.19-20.651 1.667-7.396 6.603-13.385 13.544-16.432 9.535-4.183 20.519-1.708 27.334 6.158l57.579 66.448.017.02 63.645 73.447c-4.208.226-8.704.412-12.012.412-8.831 0-17.355-.417-25.377-1.239l-54.075-62.404a73.995 73.995 0 0 0-33.027-21.904 61.986 61.986 0 0 1-27.67-18.351zM288.313 495.89h-36.435c-18.843 0-36.244-9.455-46.698-24.505 20.782 6.26 42.599 9.505 64.915 9.505s44.133-3.245 64.915-9.505c-10.454 15.05-27.855 24.505-46.698 24.505zm-18.217-27c-101.479 0-186.519-71.676-207.19-167.058 11.368 14.765 28.308 28.237 50.268 39.676 42.016 21.886 97.745 33.938 156.921 33.938s114.906-12.053 156.921-33.938c21.96-11.44 38.9-24.911 50.268-39.676-20.671 95.382-105.71 167.058-207.19 167.058z" opacity="1"></path>
                            </g>
                        </svg>
                        Platters
                    </a>
                    <a class="nav-link  " id="v-pills-BakedSubs-tab" data-toggle="pill" href="#v-pills-BakedSubs" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                            <g>
                                <path d="M502.728 134.181c5.547-9.166 7.14-22.147 8.462-32.66 1.401-11.146 1.208-22.621-2.37-33.374-6.529-19.621-23.025-34.808-43.41-38.783-26.112-5.092-51.604 6.547-71.709 24.474-.488-1.06-1.382-2.014-2.783-2.717-28.733-14.403-62.497-1.284-85.552 18.104-12.011 10.102-21.67 22.724-30.731 35.452-10.86 15.256-22.08 30.075-34.45 44.154-23.714 26.992-50.014 52.1-77.695 75.001-14.09 11.656-28.752 23.41-45.054 31.848-15.298 7.918-31.714 11.342-47.502 17.823-13.393 5.498-22.759 15.156-28.826 28.189-4.133 8.879-9.216 22.4-4.549 31.943-3.275 1.858-6.455 3.882-9.469 6.172C9.311 353.32-.249 374.941.005 397.162c.246 21.451 9.58 41.529 28.411 52.634 12.987 7.659 42.561 16.693 56.703 5.363 26.263 32.303 75.874 31.532 112.951 25.232 43.497-7.391 85.737-22.059 122.906-46.044 39.596-25.552 72.341-60.35 102.468-96.253 35.189-41.935 63.493-90.575 78.161-143.588 5.427-19.616 8.84-39.975-.137-58.868a5.738 5.738 0 0 0 1.26-1.457zM87.2 277.914c28.069-10.298 54.298-23.48 78.279-41.542 24.698-18.602 47.7-39.464 69.18-61.687 22.033-22.794 40.031-47.889 59.445-72.776 20.383-26.13 54.951-56.2 90.434-39.874.185.085.366.124.55.191-9.496 10.105-17.368 21.472-22.95 32.671-.578.164-1.142.328-1.677.486-13.347 3.955-26.871 10.496-37.192 19.925-10.939 9.993-13.954 21.087-16.643 35.028-1.985 10.292-4.327 15.68-15.735 16.417-7.646.495-13.91 1.208-20.689 5.223-16.194 9.591-16.921 23.695-20.372 40.38-2.179 10.535-6.915 16.122-17.869 16.058-6.764-.04-13.538-1.359-20.28-.218-14.116 2.388-27.87 11.868-32.203 25.861-3.376 10.902-3.484 23.503-16.365 27.38-8.544 2.571-18.247 1.238-27.048 2.344-14.46 1.817-32.137 7.061-39.597 20.896-1.675 3.106-2.668 6.758-2.933 10.466-11.001-1.398-23.439 4.495-33.493 8.11-5.674 2.04-11.322 4.259-16.77 6.867.702-24.511 22.36-44.293 43.928-52.206zm291.507-167.623c-6.79 10.15-22.244 11.734-32.707 16.218-10.608 4.548-19.494 12.514-23.702 23.422-2.537 6.577-1.922 13.461-3.974 20.059-2.118 6.81-7.715 10.377-13.7 13.555-10.285 5.462-21.444 9.659-27.744 20.121-7.476 12.416-6.2 27.079-16.597 38.38-6.989 7.597-15.975 12.062-26.258 12.724-7.466.481-15.178-.221-22.286 2.598-14.382 5.704-13.236 20.299-19.769 31.845-10.278 18.163-34.777 11.122-51.51 16.718-10.453 3.496-22.798 9.118-26.413 20.297-.426.604-.867 1.107-1.326 1.416-6.65 4.485-11.48-4.284-11.826-9.588-1.245-19.091 23.519-25.01 38.082-26.169 11.606-.924 24.721 1.433 34.758-5.978 13.216-9.758 8.365-27.983 18.811-39.086 12.239-13.009 26.299-9.51 41.804-10.056 10.97-.387 18.294-5.941 21.541-16.501 2.095-6.816 1.859-14.012 3.178-20.962 2.131-11.234 9.975-20.244 21.144-23.374 11.496-3.222 23.327 2.528 30.048-10.442 5.437-10.491 2.934-23.262 8.705-33.639 7.995-14.376 24.356-23.021 39.522-27.77 6.403-2.003 29.459-7.598 20.219 6.212zm106.072 92.867c-13.804 42.444-36.277 82.32-64.246 117.008-26.609 33.002-56.248 65.903-90.292 91.387-32.318 24.192-68.288 40.33-107.278 50.325-36.112 9.257-78.392 17.785-113.177-.492-18.831-9.894-28.662-26.531-28.621-47.799.041-21.143 8.45-40.185 26.313-52.111 17.777-11.87 39.437-17.791 59.565-24.309 19.559-6.334 38.558-13.614 56.646-23.46 34.973-19.037 65.791-45.826 89.985-77.355 25.624-33.393 45.414-75.581 80.896-100.067 29.267-20.197 83.516-38.794 96.881 9.895 5.285 19.245-.69 38.588-6.672 56.978zm12.841-100.925c-1.002 6.87-3.423 13.709-4.845 20.576a46.955 46.955 0 0 0-7.446-6.396c-19.151-18.248-52.078-11.269-74.955-1.573-36.677 15.547-60.804 47.104-83.59 78.521-13.602 18.754-26.883 37.945-42.858 54.799-16.573 17.484-35.956 32.488-56.408 45.148-21.42 13.259-43.801 23.432-67.421 32.092-20.974 7.69-41.972 15.272-59.483 29.547-24.735 20.164-37.037 59.178-22.728 88.836-5.56.729-11.231 2.556-16.889 2.282-9.513-.461-19.053-3.204-27.26-8.058-16.321-9.652-23.203-28-21.932-46.394 3.11-44.998 46.805-55.899 82.136-69.553 1.242 6.319 4.94 11.885 11.607 14.044 4.793 1.552 9.05.555 12.579-3.05 2.109-2.154 3.394-4.969 4.854-7.552 1.165-2.062 2.454-3.879 3.831-5.626 10.642-7.621 27.133-8.622 38.787-9.283 14.611-.828 28.861-5.461 35.255-19.767 2.814-6.298 3.566-13.673 7.15-19.604 6.558-10.854 20.059-7.592 30.637-8.802 13.625-1.559 25.798-10.368 33.277-21.646 9.115-13.743 6.576-31.841 21.387-41.704 10.532-7.015 24.856-9.636 31.493-21.46 3.349-5.965 3.034-12.313 4.16-18.832 1.721-9.958 7.699-17.695 16.422-22.595 11.24-6.315 24.93-7.195 35.183-15.552 6.351-5.176 13.275-17.144 5.87-24.36-3.363-3.278-8.271-3.965-13.256-3.568 2.379-2.604 4.432-5.584 6.582-8.486 5.813-7.849 12.505-14.805 19.862-21.225 14.867-12.973 34.553-24.744 54.879-24.521 19.894.218 36.898 15.95 42.151 34.682 2.637 9.4 2.368 19.495.969 29.08z" opacity="1" class=""></path>
                            </g>
                        </svg>
                        Baked Subs
                    </a>
                    <a class="nav-link  " id="v-pills-Chicken-tab" data-toggle="pill" href="#v-pills-Chicken" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 512.001 512.001" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                            <g>
                                <path d="M460.151 121.862c-5.531 0-10.001 4.481-10.001 10.001a9.992 9.992 0 0 0 10.001 10.001c5.521 0 10.001-4.471 10.001-10.001.001-5.521-4.48-10.001-10.001-10.001zM340.134 61.853c-5.531 0-10.001 4.481-10.001 10.001a9.992 9.992 0 0 0 10.001 10.001c5.521 0 10.001-4.471 10.001-10.001.001-5.52-4.48-10.001-10.001-10.001zM300.128 141.865c-5.531 0-10.001 4.481-10.001 10.001a9.992 9.992 0 0 0 10.001 10.001c5.521 0 10.001-4.471 10.001-10.001.001-5.521-4.48-10.001-10.001-10.001zM280.126 81.856c-5.531 0-10.001 4.481-10.001 10.001a9.992 9.992 0 0 0 10.001 10.001c5.521 0 10.001-4.471 10.001-10.001 0-5.52-4.481-10.001-10.001-10.001zM462.505 161.904c-5.491-.583-10.42 3.39-11.008 8.881-2.44 22.824-12.373 43.531-28.724 59.883-15.446 15.455-34.99 25.239-56.519 28.292-5.469.775-9.273 5.838-8.498 11.307.708 4.994 4.989 8.599 9.889 8.599.467 0 .941-.033 1.417-.101 25.857-3.667 49.322-15.409 67.856-33.955 19.618-19.617 31.537-44.479 34.468-71.898.587-5.492-3.39-10.42-8.881-11.008z" opacity="1"></path>
                                <path d="M465.211 46.788c-62.394-62.384-163.917-62.385-226.315.002-24.716 24.726-40.368 56.029-45.264 90.525-6.535 45.959-9.255 91.302-39.027 121.073-.526.653-8.258 7.288-12.483 19.608a49.884 49.884 0 0 0 .712 34.589l-57.456 57.459c-19.496-19.495-51.216-19.495-70.71-.002-19.555 19.543-19.556 51.17-.002 70.724 11.553 11.554 27.395 16.261 42.448 14.123-2.138 15.05 2.568 30.896 14.12 42.448 19.547 19.546 51.174 19.559 70.722 0 19.496-19.496 19.496-51.217.015-70.698l-.014-.014 57.474-57.474c19.5 7.665 40.993 2.166 54.295-11.883 28.377-29.489 77.771-32.761 120.956-38.898 34.496-4.896 65.8-20.547 90.53-45.267 62.385-62.396 62.385-163.919-.001-226.315zm-345.36 373.656c-4.622 4.623-3.636 12.378 2.002 15.693 16.771 9.865 19.849 33.167 5.957 47.059-11.725 11.732-30.695 11.735-42.431-.002-11.697-11.696-11.697-30.727 0-42.423a10.002 10.002 0 0 0-14.145-14.145c-11.696 11.696-30.727 11.697-42.423 0-11.732-11.733-11.74-30.703 0-42.435 13.868-13.87 37.175-10.838 47.056 5.959 3.315 5.637 11.068 6.626 15.693 2.002l62.478-62.479a49.966 49.966 0 0 0 17.09 11.202 49.92 49.92 0 0 0 11.201 17.091l-62.478 62.478zm331.22-161.485c-21.638 21.63-49.024 35.326-79.198 39.609-46.717 6.636-99.473 10.451-132.607 44.884-.12.126-.24.245-.366.371-16.548 16.55-44.358 8.47-50.193-13.434a9.998 9.998 0 0 0-7.09-7.09c-16.552-4.411-26.345-22.102-20.579-38.791 2.509-7.315 7.413-11.621 7.645-11.907 34.399-33.141 38.208-86.42 44.754-132.473 4.284-30.173 17.98-57.559 39.606-79.194 54.597-54.587 143.431-54.587 198.026 0 54.588 54.596 54.588 143.431.002 198.025z" opacity="1"></path>
                            </g>
                        </svg>
                        Chicken
                    </a>
                    <a class="nav-link  " id="v-pills-Salads-tab" data-toggle="pill" href="#v-pills-Salads" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 64 64" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                            <g>
                                <path d="M57.351 28.063a9.209 9.209 0 0 0-2.657-.5c-.18-.014-.4-.03-.578-.052.089-.118.193-.248.28-.358a7.093 7.093 0 0 0 1.579-2.928c.58-2.533.709-7.3-2.486-9.1a5.825 5.825 0 0 0-4.607-.389 8.2 8.2 0 0 0-4.77 3.8c-1.138 2.2-.528 4.437-.037 6.234.3 1.112.59 2.162.231 2.5-.417.4-1.661.065-2.865-.264-.377-.1-.764-.2-1.152-.3A8.007 8.007 0 0 0 33 22h-.082a9.293 9.293 0 0 0-.568-2.22c-1.994-5.063-7.593-7.623-11.266-6.532a6 6 0 0 0-2.719 1.766 10.015 10.015 0 0 0-3.108-2.884 11.494 11.494 0 0 0-9.159-.7 6.042 6.042 0 0 0-3.848 3.2c-.933 2.362.8 5.043 3.95 9.91.336.52.687 1.029 1.035 1.541a18.192 18.192 0 0 0-2.413 1.1 5.252 5.252 0 0 0-2.449 2.449A9.9 9.9 0 0 0 2 33a29.033 29.033 0 0 0 29 29h2a29.033 29.033 0 0 0 29-29 1.784 1.784 0 0 0-.108-.452 8.659 8.659 0 0 0-4.541-4.485Zm-16.429.884c1.741.472 3.539.96 4.77-.225 1.215-1.164.756-2.846.312-4.473s-.895-3.283-.116-4.789a6.2 6.2 0 0 1 3.567-2.8 3.919 3.919 0 0 1 3.054.216c2.013 1.134 2.01 4.751 1.516 6.906a5.256 5.256 0 0 1-1.189 2.118c-.548.685-1.23 1.536-.731 2.546.482.963 1.523 1.041 2.441 1.109a7.322 7.322 0 0 1 2.1.38A5.77 5.77 0 0 1 59.215 32H49.2a76.54 76.54 0 0 1 .775-3.771 75.651 75.651 0 0 1 1.973-6.909l-1.894-.64a77.64 77.64 0 0 0-2.027 7.091A77.96 77.96 0 0 0 47.168 32h-6.43a7.541 7.541 0 0 0 .184-3.053ZM34 26v-1.91a6.01 6.01 0 0 1 4.766 4.268l-2.082.694.632 1.9 1.663-.554A5.826 5.826 0 0 1 38.654 32H27.346A5.886 5.886 0 0 1 27 30a6.026 6.026 0 0 1 .031-.6l1.653.551.632-1.9-1.748-.583A6.01 6.01 0 0 1 32 24.09V26ZM21.655 15.169c2.726-.812 7.276 1.393 8.835 5.349a7.294 7.294 0 0 1 .449 1.761 7.959 7.959 0 0 0-5.688 9.682l-.083.039h-4.612c.428-.445.847-.9 1.228-1.38a20.483 20.483 0 0 0 4.21-10.511l-1.988-.218a18.6 18.6 0 0 1-3.79 9.489c-.056.071-.124.133-.181.2a17 17 0 0 0-.582-12.747 4.346 4.346 0 0 1 2.202-1.664Zm-17.544.2a4.2 4.2 0 0 1 2.646-2.044 9.56 9.56 0 0 1 7.5.543c4.784 2.762 5.878 10.721 3.627 15.724-.079.176-.172.338-.262.5a27.489 27.489 0 0 0-.674-2.409 29.153 29.153 0 0 0-8.277-12.424l-1.342 1.482a27.189 27.189 0 0 1 7.723 11.576A25.744 25.744 0 0 1 15.979 32H14.25a79.677 79.677 0 0 1-6.371-8.543c-2.841-4.393-4.299-6.747-3.768-8.09ZM4.2 30.437a3.164 3.164 0 0 1 1.575-1.5 15.985 15.985 0 0 1 2.643-1.154Q9.975 29.952 11.653 32h-7.6a2.727 2.727 0 0 1 .147-1.563ZM33 60h-2A27.032 27.032 0 0 1 4.018 34h55.964A27.032 27.032 0 0 1 33 60Z" opacity="1" class=""></path>
                                <path d="M32 28h2v2h-2zM34 14v2a1 1 0 0 0 1 1h4a9.01 9.01 0 0 0 9-9V6a1 1 0 0 0-1-1h-4a9.01 9.01 0 0 0-9 9Zm9-7h3v1a7.008 7.008 0 0 1-7 7h-1.3l4.948-4.241-1.3-1.518-5.34 4.577A7 7 0 0 1 43 7ZM25 8a3 3 0 1 0 3-3 3 3 0 0 0-3 3Zm4 0a1 1 0 1 1-1-1 1 1 0 0 1 1 1ZM12 5a3 3 0 1 0 3-3 3 3 0 0 0-3 3Zm4 0a1 1 0 1 1-1-1 1 1 0 0 1 1 1ZM10.855 43.481l-1.71 1.038A27.157 27.157 0 0 0 20.565 54.9l.87-1.8a25.172 25.172 0 0 1-10.58-9.619ZM23 54h2v2h-2z" opacity="1" class=""></path>
                            </g>
                        </svg>
                        Salads
                    </a>
                    <a class="nav-link  " id="v-pills-Dips-tab" data-toggle="pill" href="#v-pills-Dips" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 511 511.999" style="enable-background:new 0 0 512 512" xml:space="preserve" class="">
                            <g>
                                <path d="M233.582 169.016c-4.71-14.625-17.113-24.196-34.59-27.02 4.79-8.73 8.067-22.047 3.801-36.855-7.2-24.996-31.113-25.32-44.113-25.43 5.488-10.566 10.879-27.254 7.062-43.867-2.625-11.426-11.097-26.39-36.55-32.785C113.995-.758 97.952-.188 89.741.492c-4.015.336-7.258 3.45-7.715 7.403-.46 4 1.922 7.671 5.801 8.93 5.899 1.905 13.352 5.964 15.328 14.445 2.403 10.312-1.02 24.859-49.234 46.003-16.32 7.157-26.309 17.266-29.68 30.043-3.972 15.043 2.305 29.848 8.5 39.856-5.148 1.433-11.012 3.879-16.273 7.578C6.089 162.05.566 172.27.5 184.305c-.082 14.98 4.902 24.972 10.813 31.554a13.11 13.11 0 0 0-1.481 6.051v9.723c0 17.781 12.082 32.789 28.465 37.262l10.687 39.847c0 .004.004.004.004.008L83.93 439.047c.004.004.004.008.004.016l15.75 58.722c2.28 8.5 9.73 14.215 18.53 14.215 8.806 0 16.255-5.715 18.532-14.219l61.387-228.886c16.387-4.473 28.469-19.48 28.469-37.262v-9.723a13.1 13.1 0 0 0-1.387-5.855c8.558-8.672 15.969-23.461 8.367-47.04zM122.258 493.898c-.75 2.797-3.074 3.098-4.04 3.098s-3.292-.3-4.042-3.098l-11.719-43.695a582.164 582.164 0 0 0 28.535 11.129zm25.273-94.246a588.402 588.402 0 0 1-6.625-2.496 7.505 7.505 0 0 0-9.695 4.309 7.498 7.498 0 0 0 4.309 9.695 516.449 516.449 0 0 0 8.113 3.04l-8.738 32.585A564.217 564.217 0 0 1 97.5 431.707l-11.414-42.562a520.076 520.076 0 0 0 16.332 7.968 7.498 7.498 0 0 0 9.969-3.633c1.75-3.757.125-8.222-3.633-9.968a502.436 502.436 0 0 1-27.969-14.133l-12.168-45.371c27.29 17.344 56.633 31.926 87.547 43.472zm12.531-46.726c-34.761-13.11-67.449-30.18-97.316-50.801L54.2 270.262h19.14c28.864 20.77 60.849 37.918 95.208 51.039zm12.391-46.2c-25.629-9.89-49.867-22.109-72.379-36.464h82.16zm38.402-98.027H84.391c-4.145 0-7.504 3.356-7.504 7.5s3.36 7.504 7.504 7.504h127.207v7.93c0 11.957-8.934 21.863-20.477 23.406-.004.004-.008 0-.012.004-.527.066-1.05.121-1.562.156-.016 0-.035.004-.05.004-.52.035-1.028.05-1.52.05H48.46c-.496 0-1.004-.015-1.523-.05-.016 0-.032-.004-.051-.004a24.476 24.476 0 0 1-1.559-.156c-.008-.004-.012 0-.016-.004-11.542-1.543-20.476-11.45-20.476-23.406v-7.93h24.406c4.145 0 7.504-3.36 7.504-7.504s-3.36-7.5-7.504-7.5H25.504c-6.695-5.347-10.059-13.515-10-24.312.094-17.106 19.445-23.032 26.21-23.758.317-.031.618-.098.927-.16 3.023 3.71 6.457 7.707 9.136 10.226a7.48 7.48 0 0 0 5.137 2.032c2 0 3.992-.793 5.469-2.364 2.836-3.023 2.691-7.77-.332-10.605-4.078-3.832-11.703-13.625-14.399-17.215-4.609-6.64-12-19.668-8.902-31.398 2.145-8.133 9.277-14.907 21.2-20.133 30.64-13.438 64.902-32.758 57.82-63.153-1.172-5.011-3.305-9.109-5.926-12.453 16.273 1.364 35.351 6.711 39.277 23.797 3.18 13.844-2.523 28.008-6.75 35.422-2.898 4.8-12.355 17.96-22.016 22.445a7.503 7.503 0 1 0 6.32 13.61c7.88-3.657 14.845-10.45 19.93-16.485.208.04.41.094.622.117 2.722.348 5.835.372 9.132.399 15.153.129 26.176 1.246 30.02 14.582 3.219 11.184.094 21.047-3.035 26.34-1.559 2.101-10.172 13.43-21.324 22.582a7.501 7.501 0 0 0-1.04 10.558 7.478 7.478 0 0 0 5.801 2.747c1.676 0 3.36-.56 4.754-1.704 5.582-4.582 10.535-9.562 14.485-13.914a10.87 10.87 0 0 0 1.992.27c10.93.406 24.883 3.762 29.293 17.445 5.078 15.766 2.316 27.266-8.45 35.082zm0 0" opacity="1"></path>
                            </g>
                        </svg>
                        Dips
                    </a>
                    <a class="nav-link  " id="v-pills-Beverages-tab" data-toggle="pill" href="#v-pills-Beverages" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512" xml:space="preserve">
                            <g>
                                <path d="M382.1 18.829A8 8 0 0 0 376 16h-32a8 8 0 0 0-7.891 6.685L321.223 112H104a8 8 0 0 0-8 8v32a8 8 0 0 0 8 8h8.9l39.16 328.946A8 8 0 0 0 160 496h192a8 8 0 0 0 7.944-7.054L399.1 160h8.9a8 8 0 0 0 8-8v-32a8 8 0 0 0-8-8h-38.556l14.447-86.685a8 8 0 0 0-1.791-6.486ZM350.777 32h15.779l-13.333 80h-15.779Zm-210.34 224H168v24a40.045 40.045 0 0 0 40 40h64a24.038 24.038 0 0 1 22.624 16H149.961Zm67.585 48H208a24.027 24.027 0 0 1-24-24v-24h16v24a39.788 39.788 0 0 0 8.022 24ZM344.9 480H167.1l-1.9-16h181.6Zm3.81-32H163.294l-11.428-96h208.268Zm13.333-112H311.2a40.067 40.067 0 0 0-39.2-32h-32a24.028 24.028 0 0 1-24-24v-24h155.563Zm11.428-96H138.533l-9.524-80h253.982ZM400 128v16H112v-16Z" opacity="1"></path>
                                <circle cx="336" cy="280" r="8" opacity="1"></circle>
                                <circle cx="304" cy="280" r="8" opacity="1"></circle>
                                <circle cx="336" cy="312" r="8" opacity="1"></circle>
                            </g>
                        </svg>
                        Beverages
                    </a>
                    <a class="nav-link  " id="v-pills-Desserts-tab" data-toggle="pill" href="#v-pills-Desserts" role="tab" aria-selected="false">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" width="23" height="23" x="0" y="0" viewBox="0 0 382.498 382.498" style="enable-background:new 0 0 512 512" xml:space="preserve">
                            <g>
                                <path d="M372.65 229.378a7.846 7.846 0 0 0 0-1.04 7.967 7.967 0 0 0-.72-1.28l-.72-.96-142.32-136a7.998 7.998 0 0 0-4.24-2.16 284.442 284.442 0 0 0-36.8-2.72 38.644 38.644 0 0 0-16-7.36c-1.36-14.72.24-48 27.68-62.72a8.097 8.097 0 0 0-8-14.08c-35.6 19.28-37.92 59.44-37.12 76.72a38.958 38.958 0 0 0-18.88 10.32c-58.48 8.8-101.68 34.88-125.12 75.68v.88a8 8 0 0 0-.64 2.96v142.88a8 8 0 0 0 6.56 8l346.96 64h1.44a8 8 0 0 0 8-8V230.578a8.173 8.173 0 0 0-.08-1.2zM163.69 92.498c12.725-.044 23.076 10.235 23.12 22.96.044 12.725-10.235 23.076-22.96 23.12-12.725.044-23.076-10.235-23.12-22.96v-.08c0-12.693 10.266-22.996 22.96-23.04zm-37.68 13.44a38.445 38.445 0 0 0-1.28 9.52c-.632 21.552 16.326 39.536 37.878 40.168 21.552.632 39.536-16.326 40.168-37.878a39.052 39.052 0 0 0-3.246-16.77c9.04.48 16 1.28 19.2 1.68l121.44 116.08-308.64-56.96c19.76-28.48 51.6-47.12 94.48-55.84zm-100 197.84v-38.4l330.96 59.6.08 39.92-331.04-61.12zm0-54.64v-24l330.96 59.6.08 24.16-331.04-59.76zm0-40.08v-32l245.52 45.36 85.36 16 .16 30.48-331.04-59.84z" opacity="1"></path>
                            </g>
                        </svg>
                        Desserts
                    </a>
                </div>

                <div class="select-store-dropdown">
                    <label>Select a store...</label>
                    <select class="selectpicker">
                        <option>Antigonish - 48 Nova Landing (closed)</option>
                        <option>Ketchup</option>
                        <option>Barbecue</option>
                        <option>Mustard</option>
                        <option>Ketchup12</option>
                    </select>
                </div>
            </div>
            <div class="col-md-8">
                <div class="tab-content" id="v-pills-tabContent">
                    <div class="deal-comman-header">
                        <p>Due to an update with our map provider, some addresses are no longer working with the city name ROCKLAND. Please try using CLARENCE CREEK as your city.</p>
                    </div>

                    <div class="tab-pane fade show active" id="v-pills-deal" role="tabpanel">
                        <div class="row">
                            <div class="product-col">
                                <div class="product-bg-wrapper pro-bg-image">
                                    <div class="image-with-content ">
                                        <div class="pro-con">
                                            <h4>CREATE YOUR OWN</h4>
                                            <h3> CUSTOM PIZZA</h3>
                                            <a class="pro-order-btn checkSession" data-toggle="modal" data-target="#exampleModalLong2">
                                                Start your order
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @foreach($pizza as $piz)
                            <div class="product-col">
                                <div class="product-bg-wrapper">
                                    <p class="price">
                                        <i class="price__subtext">Starting at</i>
                                        <span><sup>$</sup>{{ $piz['price'][0] }}</span>
                                    </p>
                                    <div class="image-with-content">
                                        <div class="product-image">
                                            <img src="{{ asset('admin/images/items') ."/". $piz['img'] }}" alt="product-1" />
                                        </div>
                                        <div class="pro-con">
                                            <h4>{{ $piz['name'] }}</h4>
                                            <h3> {{ $piz['calories'] }} Cals/slice</h3>
                                            <div class="pro-btn-with-description">
                                                <p>{{ implode(', ', $piz['all']) }}</p>
                                            </div>
                                            <a href="#" class="pro-order-btn checkSession" data-toggle="modal" data-id="{{ $piz['id'] }}" data-target="#exampleModalLong2"> Order </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach

                        </div>
                    </div>
                </div>

                <div class="order-footer">
                    <div class="media">
                        <img src="{{ asset('images/pizza-icon.png')}}" alt="pizza-icon" />
                        <div class="media-body">
                            <p>Adults and youth (ages 13 and older) need an average of 2,000 calories a day, and children (ages 4 to 12) need an average of 1,500 calories a day. However, individual needs vary.</p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- ----- ORDER Model ---- -->
@if($lastPart == 'pizzas' )
<div class="modal fade custom-order-model" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="text-right">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-lg-6">
                        <div class="custom-order-header-content-wrapper">
                            <h3>CREATE YOUR OWN</h3>
                            <h2 id="nameOfPizza"></h2>
                            <img src="{{ asset('images/cp-pizza.png')}}" alt="pizza" class="w-100 img-fluid" />
                            <div class="cop-price-with-btn">
                                <p>
                                    <sup>$</sup>
                                    <span id="finalPrice" data-basePrice="" data-finalPrice="11.25">11.25</span>
                                </p>
                                <div class="qty-container">
                                    <button class="qty-btn-minus btn-light" type="button">-</button>
                                    <input type="text" name="qty" id="quantity" value="1" class="input-qty" />
                                    <button class="qty-btn-plus btn-light" type="button">+</button>
                                </div>
                                <a href="" class="pro-order-btn" id="orderBTN">Add to order</a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="cop-tab-right-part">
                            <ul class="nav nav-pills mb-3 dp-form cop-tab" id="pills-tab-order" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" data-toggle="pill" data-target="#pills-Size" type="button" role="tab" aria-controls="pills-Size" aria-selected="true">Size & Crust</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" data-toggle="pill" data-target="#pills-Sauce" type="button" role="tab" aria-controls="pills-Sauce" aria-selected="false">Sauce & Cheese</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" data-toggle="pill" data-target="#pills-meat" type="button" role="tab" aria-controls="pills-meat" aria-selected="false">Meat</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" data-toggle="pill" data-target="#pills-Veggiee" type="button" role="tab" aria-controls="pills-Veggiee" aria-selected="false">Veggiee</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" data-toggle="pill" data-target="#pills-Extras" type="button" role="tab" aria-controls="pills-Extras" aria-selected="false">Extras</button>
                                </li>
                            </ul>
                            <div class="tab-content" id="pills-tabContent">
                                <div class="tab-pane fade show active" id="pills-Size" role="tabpanel" aria-labelledby="pills-Size-tab">
                                    <div class="make-sure-box">Make sure to select a size, crust, and thickness!</div>
                                    <h4 class="pizza-label-h4">Pizza Size, Crust & Thickness</h4>

                                    <div class="">
                                        <div class="row size-flex">
                                            <div class="col-size-label">
                                                <label>Size</label>
                                                <i>Choose from 9" small to 18" extra large.</i>
                                            </div>
                                            <div class="col-size-box">
                                                <div class="">
                                                    <select class="province ingredients" id="size" name="size">
                                                        <option value="S">Small (9'')</option>
                                                        <option value="M">Medium(12'')</option>
                                                        <option value="L">Large(15'')</option>
                                                        <option value="XL">Extra-Large(18'')</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row size-flex">
                                            <div class="col-size-label">
                                                <label>Crust Type</label>
                                                <i>Gluten free crust available on medium size only.</i>
                                            </div>
                                            <div class="col-size-box">
                                                <div class="mdl-textfield del-select-box">
                                                    <select class="province" name="crust" id="crust">
                                                        <option>Standard Crust</option>
                                                        {{-- <option>Whole Grain</option>--}}
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row size-flex">
                                            <div class="col-size-label">
                                                <label>Crust Thickness</label>
                                            </div>
                                            <div class="col-size-box">
                                                <div class="mdl-textfield del-select-box">
                                                    <select class="province" name="thickness" id="thickness">
                                                        <option>Reguler</option>
                                                        <option>Thick</option>
                                                        <option>Thin</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-submit mt-5">
                                                <a class="pro-order-btn cop-border-btn" id="base&cheese"> Base Sauce & Cheese</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="pills-Sauce" role="tabpanel">
                                    <h4 class="pizza-label-h4">Base Sauce & Cheese</h4>
                                    <div class="">
                                        <div class="row size-flex">
                                            <div class="col-size-label">
                                                <label>Sauce</label>
                                                <i>Choose your sauce.</i>
                                            </div>
                                            <div class="col-size-box">
                                                <div class="mdl-textfield del-select-box">
                                                    <select class="province" name="sauce[]">
                                                        @foreach($all['sauce'] as $sauce)
                                                        <option value="{{ $sauce['id'] }}">{{ $sauce['name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row size-flex">
                                            <div class="col-size-label">
                                                <label>Cheese</label>
                                                <i>Choose your cheese.</i>
                                            </div>
                                            <div class="col-size-box">
                                                <div class="mdl-textfield del-select-box">
                                                    <select class="province" name="cheese[]">
                                                        @foreach(array_slice($all['cheese'], 2) as $cheese)
                                                        <option value="{{ $cheese['id'] }}" data-price="{{ isset($cheese['price']) ? $cheese['price'] : ''}}">{{ $cheese['name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <h4 class="pizza-label-h4">Add some extra cheese to your pizza</h4>

                                        <div class="row cf-row">
                                            @foreach($all['cheese'] as $key => $cheese)
                                            @if($key < 2) <div class="col-md-6">
                                                <div class="custom-features-section">
                                                    <input type="checkbox" class="ingredients" data-price="{{ $cheese['price'] }}" name="cheese-extra[]" />
                                                    <div class="custom-feat-wrapper">
                                                        <img src="{{ asset('' . $cheese['img'])}}" />
                                                        <span>{{ $cheese['name'] }}</span>
                                                        <img src="{{ asset('images/checked.png')}}" class="checked-img" />
                                                    </div>

                                                    <div class="cop-select-with-radio">
                                                        <div class="cop-sox">
                                                            <select class="province">
                                                                <option>Reguler (1x)</option>
                                                            </select>
                                                        </div>
                                                        <div class="pizza-size-box">
                                                            <div class="second-radio">
                                                                <input type="radio" id="" name="" checked>
                                                                <label for=""></label>
                                                                <span>Full</span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                        </div>
                                        @else
                                        @break
                                        @endif
                                        @endforeach
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-submit mt-5">
                                            <button class="pro-order-btn cop-border-btn"> Now Let's add some meat</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="pills-meat" role="tabpanel">

                                <h4 class="pizza-label-h4">Add some meat to your pizza</h4>
                                <div class="row cf-row">
                                    @foreach($all['meat'] as $meat)
                                    <div class="col-md-6">
                                        <div class="custom-features-section meat_ingredients">
                                            <input type="checkbox" name="meat[]" class="ingredients" data-price="{{ $meat['price'] }}" data-meat="{{ $meat['id'] }}" />
                                            <div class="custom-feat-wrapper">
                                                <img src="{{ asset('') . $meat['img']}}" />
                                                <span>{{ $meat['name'] }}</span>
                                                <img src="{{ asset('images/checked.png')}}" class="checked-img" />
                                            </div>

                                            <div class="cop-select-with-radio">
                                                <div class="cop-sox">
                                                    <select class="province" name="meatPortion">
                                                        <option>Easy (.5x)</option>
                                                        <option selected>Reguler (1x)</option>
                                                    </select>
                                                </div>
                                                <div class="pizza-size-box">
                                                    <div class="second-radio">
                                                        <input type="radio" id="" name="" checked>
                                                        <label for=""></label>
                                                        <span>Full</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>

                                <div class="col-md-12">
                                    <div class="form-submit mt-5">
                                        <button class="pro-order-btn cop-border-btn"> How about some veggies?</button>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="pills-Veggiee" role="tabpanel">
                                <h4 class="pizza-label-h4">Add some veggies to your pizza </h4>
                                <div class="row cf-row">
                                    @foreach($all['veggies'] as $veg)
                                    <div class="col-md-6">
                                        <div class="custom-features-section veggies_ingredient">
                                            <input type="checkbox" name="veggies[]" class="ingredients" data-price="{{ $veg['price'] }}" data-veggies="{{ $veg['id'] }}" />
                                            <div class="custom-feat-wrapper">
                                                <img src="{{ asset('') . $veg['img']}}" />
                                                <span>{{ isset($veg['name']) ? $veg['name'] : '' }}</span>
                                                <img src="{{ asset('images/checked.png')}}" class="checked-img" />
                                            </div>

                                            <div class="cop-select-with-radio">
                                                <div class="cop-sox">
                                                    <select class="province" name="veggiesPortion">
                                                        <option>Easy (.5x)</option>
                                                        <option selected>Reguler (1x)</option>
                                                    </select>
                                                </div>
                                                <div class="pizza-size-box">
                                                    <div class="second-radio">
                                                        <input type="radio" id="" name="" checked>
                                                        <label for=""></label>
                                                        <span>Full</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>

                                <div class="col-md-12">
                                    <div class="form-submit mt-5">
                                        <button class="pro-order-btn cop-border-btn">And some free extras?</button>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="pills-Extras" role="tabpanel">
                                <h4 class="pizza-label-h4">Add some free toppings </h4>
                                <div class="row cf-row">
                                    @foreach($all['extra-sauce'] as $extraSauce)
                                    <div class="col-md-6">
                                        <div class="custom-features-section extraSauce_ingredient">
                                            <input type="checkbox" name="extraSauce[]" class="ingredients" data-price="0" data-sauce="{{ $extraSauce['id'] }}" />
                                            <div class="custom-feat-wrapper">
                                                <img src="{{ asset('') . $extraSauce['img']}}" />
                                                <span>{{ isset($extraSauce['name']) ? $extraSauce['name'] : '' }}</span>
                                                <img src="{{ asset('images/checked.png')}}" class="checked-img" />
                                            </div>

                                            <div class="cop-select-with-radio">
                                                <div class="cop-sox">
                                                    <select class="province">
                                                        <option checked>Reguler (1x)</option>
                                                    </select>
                                                </div>
                                                <div class="pizza-size-box">
                                                    <div class="second-radio">
                                                        <input type="radio" id="" name="" checked>
                                                        <label for=""></label>
                                                        <span>Full</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>
</div>
@endif

<!-- ----- Order setup Modal ---- -->
<div class="modal fade" id="orderSetup" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="text-right">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="order-header-content-wrapper">
                    <h2>ORDER SETUP</h2>
                    @guest
                    <div class="ls-btn-group">
                        <button class="pro-order-btn" data-toggle="modal" data-target="#login" data-dismiss="modal"> Log in </button>
                        <button class="pro-order-btn btn-transparent" data-toggle="modal" data-target="#register" data-dismiss="modal"> Sign up</button>
                    </div>
                    <p>Eat pizza. Get points. Get free pizza. Repeat. It's the pizza cycle of life. Become a Pizza Perks member and start earning today.</p>
                    <img src="{{ asset('images/perks.png') }}" alt="perks" />
                    <p>To continue as a <b> guest </b> select delivery or pickup and provide us some details to get you started!</p>
                    @endguest

                    @auth
                    <img src="{{ asset('images/perks.png') }}" alt="perks" />
                    <p>Select delivery or pickup and provide us some details to get you started!</p>
                    @endauth
                </div>
                <ul class="nav nav-pills mb-3 dp-form" id="pills-tab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="pills-home-tab" data-toggle="pill" data-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">Delivery</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-profile-tab" data-toggle="pill" data-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">Pickup</button>
                    </li>
                </ul>
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                        <div class="delivery-form-content">
                            <form id="deliveryForm" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="text" name="name">
                                            <label class="mdl-textfield__label">Name<span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="email" name="email">
                                            <label class="mdl-textfield__label">Email<span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="number" name="phone">
                                            <label class="mdl-textfield__label">Phone # <span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="text" name="street">
                                            <label class="mdl-textfield__label">Street # <span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="text" name="apartment">
                                            <label class="mdl-textfield__label">Apartment # <span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="text" name="streetName">
                                            <label class="mdl-textfield__label">Street name <span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="number" name="postCode">
                                            <label class="mdl-textfield__label">Postal code <span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="text" name="city">
                                            <label class="mdl-textfield__label">City <span class="required"> *</span></label>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-submit">
                                            <button class="pro-order-btn"> Continue </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                        <div class="delivery-form-content">
                            <form id="pickupForm" enctype="multipart/form-data">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="text" name="name">
                                            <label class="mdl-textfield__label">Name<span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="email" name="email">
                                            <label class="mdl-textfield__label">Email<span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                            <input class="mdl-textfield__input" type="number" name="phone">
                                            <label class="mdl-textfield__label">Phone # <span class="required"> *</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-submit">
                                            <button class="pro-order-btn pickUpSave"> Save </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<input type="hidden" id="boolDelivery" value="{{ !empty(session()->get('delivery_details')) ? 'yes' : '' }}">
<input type="hidden" id="boolPickUp" value="{{ !empty(session()->get('pickup_details')) ? 'yes' : '' }}">

<!-- --- login model ----- -->
<div class="modal fade" id="login" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="text-right">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="order-header-content-wrapper">
                    <h2>SIGN IN </h2>
                    <p style="width: 90%;margin: auto;">Sign in to your account and start earning Pizza Perks points on your next order. </p>
                    <img src="{{ asset('images/perks.png') }}" alt="perks" />
                </div>
                <div class="delivery-form-content sign-in-form">
                    <form id="loginForm" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                    <input class="mdl-textfield__input" type="email" name="email">
                                    <label class="mdl-textfield__label">Email<span class="required"> *</span></label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                    <input class="mdl-textfield__input" type="password" name="password">
                                    <label class="mdl-textfield__label">Password <span class="required"> *</span></label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-submit">
                                    <button type="submit" class="pro-order-btn"> Sign in </button>
                                </div>
                            </div>
                            <div class="login-form-footer-link">
                                <a href="" data-toggle="modal" data-target="#forgotPassword" data-dismiss="modal"><i>I forgot my password</i></a>
                                <a href="" data-toggle="modal" data-target="#register" data-dismiss="modal"><i>Don't have an account yet? Create one!</i></a>
                            </div>
                        </div>
                    </form>
                </div>


            </div>
        </div>
    </div>
</div>

<!-- --- Register model ----- -->
<div class="modal fade" id="register" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="text-right">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="order-header-content-wrapper">
                    <h2>REGISTER </h2>
                    <p>Eat pizza. Get points. Get free pizza. Repeat. It's the pizza cycle of life. Become a Pizza Perks member and start earning today.</p>
                    <img src="{{ asset('images/perks.png') }}" alt="perks" />
                </div>
                <div class="delivery-form-content sign-in-form">
                    <form id="registerForm" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                    <input class="mdl-textfield__input" type="email" name="email">
                                    <label class="mdl-textfield__label">Email<span class="required"> *</span></label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                    <input class="mdl-textfield__input" type="password" name="password">
                                    <label class="mdl-textfield__label">Password <span class="required"> *</span></label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                    <input class="mdl-textfield__input" type="number" name="phone">
                                    <label class="mdl-textfield__label">Phone #<span class="required"> *</span></label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                    <input class="mdl-textfield__input" type="text" name="firstname">
                                    <label class="mdl-textfield__label">First name <span class="required"> *</span></label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-submit">
                                    <button type="submit" class="pro-order-btn registerbtn"> Register </button>
                                </div>
                            </div>
                            <div class="login-form-footer-link">
                                <a href="" data-toggle="modal" data-target="#login" data-dismiss="modal"><i>Already registered? Sign in!</i></a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ---forget model----- -->
<div class="modal fade" id="forgotPassword" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="text-right">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="forgotpassword-content">
                    <h2>FORGOT PASSWORD</h2>
                    <p>Forgot your password? Let us help! Enter your email and we will send you a link to reset your password. </p>
                </div>

                <div class="delivery-form-content sign-in-form">
                    <form method="get" action="#">
                        <div class="row justify-content-center">
                            <div class="col-md-6">
                                <div class="mdl-textfield mdl-js-textfield mdl-textfield--floating-label">
                                    <input class="mdl-textfield__input" type="email" name="">
                                    <label class="mdl-textfield__label">Email<span class="required"> *</span></label>
                                </div>
                            </div>
                            <div class="col-md-12 mt-5">
                                <div class="form-submit">
                                    <button type="submit" class="pro-order-btn"> Submit </button>
                                </div>
                            </div>
                            <div class="login-form-footer-link">
                                <a href="" data-toggle="modal" data-target="#login" data-dismiss="modal"><i>Nevermind, I remember it!</i></a>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>

    </div>
</div>
@endsection

@push('js')
<script src="{{ asset('js/jquery-3.6.0.js') }}"></script>
<script src="{{ asset('js/jquery.validate.js') }}"></script>
<script src="{{ asset('js/popper.min.js') }}"></script>
<script src="{{ asset('js/bootstrap.min.js')}}"></script>
<script src="{{ asset('js/selectize.min.js') }}"></script>
<script src="{{ asset('js/stickybits.min.js') }}"></script>
<script src="{{ asset('js/owlCarousel.min.js') }}"></script>
<script src="{{ asset('js/wow.js')}}"></script>
<script src="{{ asset('js/all.js') }}"></script>
<script defer src="{{ asset('js/material.min.js') }}"></script>
<script src="{{ asset('js/toastr.js') }}"></script>
<script>
    $(document).ready(function() {

        stickybits('.main-header', {
            useStickyClasses: true
        });

        $(".selectpicker, .province, .s-store").selectize();

        $('.order-mobile-btn button').on('click', function() {
            $('.sidemenu').toggleClass('visible');
        });
        $('#body-overlay').click(function() {
            $('.sidemenu').removeClass('visible');
        });

        $(window).on('load', function() {
            setTimeout(function() {
                $("#preloader").delay(600).fadeOut(600).addClass('loaded');
            }, 700);
        });

        var sync1 = $("#sync1");
        var sync2 = $("#sync2");
        var slidesPerPage = 4; //globaly define number of elements per page
        var syncedSecondary = true;

        sync1.owlCarousel({
            items: 1,
            slideSpeed: 500000,
            nav: false,
            autoplay: true,
            dots: false,
            loop: true,
            responsiveRefreshRate: 200,
            animateOut: 'fadeOut',
            mouseDrag: false,
            touchDrag: false,
        }).on('changed.owl.carousel', syncPosition);

        sync2.on('initialized.owl.carousel', function() {
                sync2.find(".owl-item").eq(0).addClass("current");
            })
            .owlCarousel({
                items: slidesPerPage,
                dots: false,
                nav: false,
                smartSpeed: 5000,
                slideSpeed: 5000,
                slideBy: slidesPerPage, //alternatively you can slide by 1, this way the active slide will stick to the first item in the second carousel
                responsiveRefreshRate: 100,
                mouseDrag: false,
                touchDrag: false,
            }).on('changed.owl.carousel', syncPosition2);

        function syncPosition(el) {
            //if you set loop to false, you have to restore this next line
            //var current = el.item.index;

            //if you disable loop you have to comment this block
            var count = el.item.count - 1;
            var current = Math.round(el.item.index - (el.item.count / 2) - .5);

            if (current < 0) {
                current = count;
            }
            if (current > count) {
                current = 0;
            }

            //end block
            sync2
                .find(".owl-item")
                .removeClass("current")
                .eq(current)
                .addClass("current");
            var onscreen = sync2.find('.owl-item.active').length - 1;
            var start = sync2.find('.owl-item.active').first().index();
            var end = sync2.find('.owl-item.active').last().index();

            if (current > end) {
                sync2.data('owl.carousel').to(current, 100, true);
            }
            if (current < start) {
                sync2.data('owl.carousel').to(current - onscreen, 100, true);
            }
        }

        function syncPosition2(el) {
            if (syncedSecondary) {
                var number = el.item.index;
                sync1.data('owl.carousel').to(number, 100, true);
            }
        }

        sync2.on("click", ".owl-item", function(e) {
            e.preventDefault();
            var number = $(this).index();
            sync1.data('owl.carousel').to(number, 300, true);
        });
    });

    //This function is to set the cart Price and atlast to show it
    function cart() {
        $.ajax({
            url: '{{ route("get-cart") }}',
            method: 'POST',
            data: {
                '_token': "{{ csrf_token() }}",
            },
            success: function(data) {
                if (data.status == 'success') {
                    var totalPrice = 0;

                    // Loop through each item in the cart
                    data.cart.forEach(function(item) {
                        // Assuming each item has a 'price' property
                        totalPrice += parseFloat(item.price);
                    });

                    // Update the HTML element with the calculated total price
                    $('.app__total').text('$' + totalPrice.toFixed(2));
                }
            },
            error: function(xhr, status, error) {
                console.error('Error adding items to cart:', error);
            }
        });
    }

    $(document).ready(function() {
        //These are functionality based and this is what inserting the pizza data in modal
        $(document).on('click', '.checkSession', function(e) {
            e.preventDefault();
            $('#exampleModalLong').modal('hide');
            // var login = $('#boolPickUp').val();
            var delivery = $('#boolDelivery').val();
            var pickup = $('#boolPickUp').val();

            if (delivery || pickup) {
                var idOfPizza = $(this).data('id');
                $.ajax({
                    url: '{{route("getPizzaDetails")}}',
                    type: "POST",
                    dataType: "JSON",
                    data: {
                        '_token': "{{ csrf_token() }}",
                        'id': idOfPizza
                    },
                    cache: false,
                    async: false,

                    success: function(data) {
                        if (data.status == 'success') {
                            var sizes = data.data['size'].split(",");
                            var price = data.data['price'].split(",");

                            $('#nameOfPizza').text(data.data['name'].toUpperCase());
                            $('.ingredients').prop('checked', false);
                            $('#size option').each(function(index) {
                                console.log($(this).val());
                                console.log(price[index]);
                                $(this).attr('data-price', price[index]);
                                $(this).text($(this).text() + ' - $' + price[index]);
                            });

                            //This is for Meat
                            if (data.data.meat_ingredients && data.data.meat_ingredients.trim() !== '') {
                                var selectedMeatIDs = data.data.meat_ingredients.split(', ');

                                selectedMeatIDs.forEach(function(meatID) {
                                    // Select the checkbox with the corresponding data-meat attribute
                                    $('input[data-meat="' + meatID + '"]').prop('checked', true);

                                    // Select the corresponding option in the select element within the same meat_ingredients div
                                    $('input[data-meat="' + meatID + '"]').closest('.meat_ingredients').find('select[name="meatPortion"]').val('Reguler (1x)');

                                    // Select the default radio button within the same meat_ingredients div
                                    $('input[data-meat="' + meatID + '"]').closest('.meat_ingredients').find('.second-radio input[type="radio"]').prop('checked', true);
                                });
                            }

                            //This is for Veggies
                            if (data.data.veggies && data.data.veggies.trim() !== '') {
                                var veggiesIDS = data.data.veggies.split(', ');

                                veggiesIDS.forEach(function(veggiesID) {
                                    // Select the checkbox with the corresponding data-meat attribute
                                    $('input[data-veggies="' + veggiesID + '"]').prop('checked', true);

                                    // Select the corresponding option in the select element within the same meat_ingredients div
                                    $('input[data-veggies="' + veggiesID + '"]').closest('.veggies_ingredients').find('select[name="veggiesPortion"]').val('Reguler (1x)');

                                    // Select the default radio button within the same meat_ingredients div
                                    $('input[data-veggies="' + veggiesID + '"]').closest('.veggies_ingredients').find('input[name="radio-group"][checked]').prop('checked', true);
                                });
                            }

                        } else {

                        }
                    }
                });


                $('#exampleModalLong').modal('show');
                $('#exampleModalLong #idOfPizza').val(idOfPizza);
            } else {
                $('#orderSetup').modal('show');
            }
        });
    });

    $(document).on('click', '#delivery_submit', function(e) {
        e.preventDefault();
        var formData = new FormData($('#delivery_form')[0]);

        $('#delivery_form')[0].reset();
        $.ajax({
            url: "{{ route('ordering') }}",
            type: 'POST',
            dataType: "JSON",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.status == 1) {
                    $('#exampleModalLong').modal('hide');
                    toastr.success('Your order number is #' + response.message);
                } else if (response.status == 0) {
                    $('#exampleModalLong').modal('hide');
                    toastr.error(response.message);
                }
            },
            error: function(xhr, status, error) {
                console.log('Error:' + error);
            }
        });
    });

    //To take the delivery address if the user is guest.
    $("#deliveryForm").validate({
        rules: {
            name: {
                required: true
            },
            email: {
                required: true,
                email: true
            },
            phone: {
                required: true
            },
            city: {
                required: true
            },
            postCode: {
                required: true
            },
            streetName: {
                required: true
            },
            apartment: {
                required: true
            },
            street: {
                required: true
            },
        },
        messages: {
            name: {
                required: "Please enter your name"
            },
            email: {
                required: "Please enter email address",
                email: "Please enter your email address properly"
            },
            phone: {
                required: "Please enter your phone number"
            },
            city: {
                required: "Please enter your city"
            },
            postCode: {
                required: "Please enter your postcode"
            },
            streetName: {
                required: "Please enter the street name"
            },
            apartment: {
                required: "Please enter your Apartment"
            },
            street: {
                required: "Please enter Street"
            },
        },
        errorClass: "text-danger",
        submitHandler: function(form, e) {
            e.preventDefault();
            let data = new FormData(form);
            $.ajax({
                url: '{{route("delivery-setup")}}',
                type: "POST",
                dataType: "JSON",
                data: data,
                cache: false,
                async: false,
                processData: false,
                contentType: false,
                success: function(data) {
                    if (data.status == 'success') {
                        toastr.success('Delivery address setup complete');
                        $("#deliveryForm").trigger('reset');
                        $('#orderSetup').modal('hide');
                        $('#boolDelivery').val('true');
                    } else {
                        toastr.error(data.message);
                        $("#deliveryForm").trigger('reset');
                        $('#orderSetup').modal('hide');
                    }
                }
            });
        }
    })

    $("#pickupForm").validate({
        rules: {
            name: {
                required: true
            },
            email: {
                required: true,
                email: true
            },
            phone: {
                required: true
            },
        },
        messages: {
            name: {
                required: "Please enter your name"
            },
            email: {
                required: "Please enter email address",
                email: "Please enter your email address properly"
            },
            phone: {
                required: "Please enter your phone number"
            },
        },
        errorClass: "text-danger",
        submitHandler: function(form, e) {
            e.preventDefault();
            let data = new FormData(form);
            $.ajax({
                url: '{{route("pickup-setup")}}',
                type: "POST",
                dataType: "JSON",
                data: data,
                cache: false,
                async: false,
                processData: false,
                contentType: false,
                success: function(data) {
                    if (data.status == 'success') {
                        toastr.success('Delivery address setup complete');
                        $("#deliveryForm").trigger('reset');
                        $('#orderSetup').modal('hide');
                        $('#boolPickUp').val('true');
                    } else {
                        toastr.error(data.message);
                        $("#deliveryForm").trigger('reset');
                        $('#orderSetup').modal('hide');
                    }
                }
            });
        }
    })

    $("#registerForm").validate({
        rules: {
            name: {
                required: true
            },
            email: {
                required: true,
                email: true
            },
            phone: {
                required: true
            },
            password: {
                required: true
            },
            firstname: {
                required: true
            },
        },
        messages: {
            name: {
                required: "Please enter your name"
            },
            email: {
                required: "Please enter email address",
                email: "Please enter your email address properly"
            },
            password: {
                required: "Please enter password"
            },
            phone: {
                required: "Please enter your phone number"
            },
            firstname: {
                required: "Please enter your name"
            },
        },
        errorClass: "text-danger",
        submitHandler: function(form, e) {
            e.preventDefault();
            let data = new FormData(form);
            $.ajax({
                url: '{{route("register")}}',
                type: "POST",
                dataType: "JSON",
                data: data,
                cache: false,
                async: false,
                processData: false,
                contentType: false,
                success: function(data) {
                    if (data.status == 'success') {
                        toastr.success(data.message);
                        $('#register').modal('hide');
                        $("#registerForm").trigger('reset');
                        $('#orderSetup').modal('show');
                        // $('#boolPickUp').val('true');
                    } else {
                        toastr.error(data.message);
                        $('#register').modal('hide');
                        $("#registerForm").trigger('reset');
                    }
                }
            });
        }
    })

    $("#loginForm").validate({
        rules: {
            email: {
                required: true,
                email: true
            },
            password: {
                required: true
            },
        },
        messages: {
            email: {
                required: "Please enter email address",
                email: "Please enter your email address properly"
            },
            password: {
                required: "Please enter password"
            },
        },
        errorClass: "text-danger",
        submitHandler: function(form, e) {
            e.preventDefault();
            let data = new FormData(form);
            $.ajax({
                url: '{{route("user.login")}}',
                type: "POST",
                dataType: "JSON",
                data: data,
                cache: false,
                async: false,
                processData: false,
                contentType: false,
                success: function(data) {
                    if (data.status == 'success') {
                        toastr.success(data.message);
                        $('#login').modal('hide');
                        $("#loginForm").trigger('reset');
                        location.reload();
                        // $('#orderSetup').modal('show');
                        // $('#boolPickUp').val('true');
                    } else {
                        toastr.error(data.message);
                        $('#login').modal('hide');
                        $("#loginForm").trigger('reset');
                    }
                }
            });
        }
    })

    //final order system
    $(document).on('change', '.ingredients', function(e) {
        if ($(this).is(':checked')) {
            // If checked, add to finalPrice
            var priceToAdd = parseFloat($(this).data('price'));
            console.log(priceToAdd);
            var currentPrice = parseFloat($('#finalPrice').text());
            var newPrice = currentPrice + priceToAdd;
            $('#finalPrice').text(newPrice.toFixed(2));
        } else {
            // If unchecked, subtract from finalPrice
            var priceToSubtract = parseFloat($(this).data('price'));
            console.log(priceToSubtract + "-");
            var currentPrice = parseFloat($('#finalPrice').text());
            var newPrice = currentPrice - priceToSubtract;
            $('#finalPrice').text(newPrice.toFixed(2));
        }
    });

    $(document).on('click', '#orderBTN', function(e) {
        e.preventDefault();

        var type = "{{ $lastPart }}";
        var size = $('#size').val();
        var quantity = $('#quantity').val();
        var price = $('#finalPrice').attr('data-finalPrice');
        var crust = $('#crust').val();
        var thickness = $('#thickness').val();
        var sauce = $('#pills-Sauce select[name="sauce[]"]').val();

        var cheese = [];
        $('#pills-Sauce select[name="cheese[]"]').each(function() {
            cheese.push($(this).val());
        });

        var meat = [];
        $('#pills-meat input[name="meat[]"]:checked').each(function() {
            meat.push($(this).data('meat'));
        });

        var veggies = [];
        $('#pills-Veggiee input[name="veggies[]"]:checked').each(function() {
            veggies.push($(this).data('veggies'));
        });

        var extraSauce = [];
        $('#pills-Extras input[name="extraSauce[]"]:checked').each(function() {
            extraSauce.push($(this).data('sauce'));
        });

        $.ajax({
            url: '{{ route("add-to-cart") }}',
            method: 'POST',
            data: {
                '_token': "{{ csrf_token() }}",
                'type': type,
                'quantity': quantity,
                'size': size,
                'price': price,
                'crust': crust,
                'thickness': thickness,
                'sauce': sauce,
                'cheese': cheese,
                'meat': meat,
                'veggies': veggies,
                'extraSauce': extraSauce
            },
            success: function(data) {
                if (data.status == 'success') {
                    cart();
                    toastr.success(data.message);
                    $('#exampleModalLong').modal('hide');
                } else {
                    toastr.error("Something went Wrong");
                    $('#exampleModalLong').modal('hide');
                }
            },
            error: function(xhr, status, error) {
                console.error('Error adding items to cart:', error);
            }
        });
    });

    // Function to handle increasing quantity
    $('.qty-btn-plus').on('click', function() {
        var inputQty = $(this).siblings('.input-qty');
        var currentValue = parseInt(inputQty.val());
        inputQty.val(currentValue + 1);

        // Update the final price by multiplying with the quantity
        var finalPrice = parseFloat($('#finalPrice').text());
        var totalPrice = finalPrice * (currentValue + 1);
        $('#finalPrice').text(totalPrice.toFixed(2));
    });

    // Function to handle decreasing quantity
    $('.qty-btn-minus').on('click', function() {
        var inputQty = $(this).siblings('.input-qty');
        var currentValue = parseInt(inputQty.val());
        if (currentValue > 1) {
            inputQty.val(currentValue - 1);
        }

        // Update the final price by multiplying with the quantity
        var finalPrice = parseFloat($('#finalPrice').text());
        var totalPrice = finalPrice * (currentValue - 1);
        $('#finalPrice').text(totalPrice.toFixed(2));
    });
</script>
@endpush