<?php $__env->startSection('title','Category'); ?>

<?php $__env->startSection('main'); ?>

    <?php
        //        echo '<pre>';
        //        print_r($category[0]['name']);
        $sauceArray = !empty($data['sauces']) ? explode(',', $data['sauces']) : [];
        $cheeseArray = !empty($data['cheese']) ? explode(',', $data['cheese']) : [];
        $meatArray = !empty($data['meat_ingredients']) ? explode(',', $data['meat_ingredients']) : [];
        $veggiesArray = !empty($data['veggies']) ? explode(',', $data['veggies']) : [];
        $extraArray = !empty($data['extra']) ? explode(',', $data['extra']) : [];
        $priceArray = !empty($data['price']) ? explode(',', $data['price']) : '';
        $sizeArray = !empty($data['size']) ? explode(',', $data['size']) : '';


    ?>


    <div class="content-body">
        <!-- row -->
        <div class="container-fluid">
            <div class="mb-sm-4 d-flex flex-wrap align-items-center text-head">
                <h2 class="mb-3 me-auto">Items</h2>
                <div>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="javascript:void(0)">Update Items</a></li>
                    </ol>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-12">
                    <form id="updateForm" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3 row">
                            <label class="col-sm-3 col-form-label">Name of this dish</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" name="name" placeholder="Name" value="<?php echo e($data['name']); ?>">
                            </div>
                        </div>

                        <div class="mb-3 row ">
                            <label class="col-sm-3 col-form-label">Category</label>
                            <div class="col-sm-9">
                                <select name="category_id" id="single-select">
                                    <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cat['id']); ?>" <?php echo e(isset($data['category_master_id']) && $data['category_master_id'] == $cat['id'] ? 'selected' : ''); ?>>
                                            <?php echo e($cat['name']); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="basic-form row mb-3">
                            <label class="col-sm-3 col-form-label">Select Pizza Sauce</label>
                            <div class="mb-3 col-sm-9 row" id="sauceSelector">
                                <?php $__currentLoopData = $sauce; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sau): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($loop->index < 2): ?>
                                        <div class="form-check pt-1 col-3">
                                            <input
                                                type="checkbox"
                                                class="form-check-input"
                                                <?php echo e(isset($data['sauces']) && $data['sauces'] == $sau['id'] ? 'checked' : ''); ?>

                                                name="sauce[]"
                                                id="sauce-<?php echo e($loop->index); ?>"
                                                value="<?php echo e($sau['id']); ?>"
                                            >
                                            <label class="form-check-label" for="sauce-<?php echo e($loop->index); ?>"><?php echo e($sau['name']); ?></label>
                                        </div>
                                    <?php else: ?>
                                        <?php break; ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <div class="basic-form row mb-3">
                            <label class="col-sm-3 col-form-label">Select Extra Sauce</label>
                            <div class="mb-3 col-sm-9 row" id="extraSauceSelector">
                                <?php $__currentLoopData = $sauce; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sau): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($loop->index >= 2): ?>
                                        <div class="form-check pt-1 col-2 ">
                                            <input
                                                type="checkbox"
                                                class="form-check-input"
                                                name="extra[]"
                                                <?php echo e(in_array($sau['id'], $extraArray) ? 'checked' : ''); ?>

                                                id="extra-<?php echo e($loop->index); ?>"
                                                value="<?php echo e($sau['id']); ?>"
                                            >
                                            <label class="form-check-label" for="extra-<?php echo e($loop->index); ?>"><?php echo e($sau['name']); ?></label>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>

                        <div class="basic-form row mb-3">
                            <label class="col-sm-3 col-form-label">Select cheese</label>
                            <div class="mb-3 col-sm-9 row" id="cheeseSelector">
                                <?php $__currentLoopData = $cheese; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ches): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check pt-1 col-2">
                                        <input
                                            type="checkbox"
                                            class="form-check-input"
                                            name="cheese[]"
                                            <?php echo e(in_array($ches['id'], $cheeseArray) ? 'checked' : ''); ?>

                                            id="cheese-<?php echo e($loop->index); ?>"
                                            value="<?php echo e($ches['id']); ?>"
                                        >
                                        <label class="form-check-label" for="cheese-<?php echo e($loop->index); ?>"><?php echo e($ches['name']); ?></label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <div class="basic-form row mb-3">
                            <label class="col-sm-3 col-form-label">Select Meat</label>
                            <div class="mb-3 col-sm-9 row" id="meatSelector">
                                <?php $__currentLoopData = $meat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check pt-1 col-2">
                                        <input type="checkbox"
                                               class="form-check-input"
                                               name="meat[]"
                                               <?php echo e(in_array($mead['id'], $meatArray) ? 'checked' : ''); ?>

                                               id="meat-<?php echo e($loop->index); ?>"
                                               value="<?php echo e($mead['id']); ?>"
                                        >
                                        <label class="form-check-label" for="meat-<?php echo e($loop->index); ?>"><?php echo e($mead['name']); ?></label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>


                        <div class="basic-form row mb-3">
                            <label class="col-sm-3 col-form-label">Select Veggies</label>
                            <div class="mb-3 col-sm-9 row" id="veggiesSelector">
                                <?php $__currentLoopData = $veggies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vegies): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check pt-1 col-2">
                                        <input
                                            type="checkbox"
                                            class="form-check-input"
                                            name="veggies[]"
                                            <?php echo e(in_array($vegies['id'], $veggiesArray) ? 'checked' : ''); ?>

                                            id="veggies-<?php echo e($loop->index); ?>"
                                            value="<?php echo e($vegies['id']); ?>"
                                        >
                                        <label class="form-check-label" for="veggies-<?php echo e($loop->index); ?>"><?php echo e($vegies['name']); ?></label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <label class="col-sm-3 col-form-label">Calories Per Slice</label>
                            <div class="col-sm-9">
                                <input
                                    type="text"
                                    class="form-control"
                                    name="calories"
                                    placeholder="Calories Per Slice"
                                    value="<?php echo e($data['calories']); ?>"
                                >
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <label class="col-sm-3 col-form-label">Prices for <?php echo e(isset($sizeArray[0]) ? $sizeArray[0] : ''); ?></label>
                            <div class="col-sm-9">
                                <input
                                    type="text"
                                    class="form-control"
                                    name="priceSM"
                                    placeholder="Price"
                                    value="<?php echo e(isset($priceArray[0]) ? $priceArray[0] : ''); ?>"
                                >
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <label class="col-sm-3 col-form-label">Prices for <?php echo e(isset($sizeArray[1]) ? $sizeArray[1] : ''); ?></label>
                            <div class="col-sm-9">
                                <input
                                    type="text"
                                    class="form-control"
                                    name="priceM"
                                    placeholder="Price"
                                    value="<?php echo e(isset($priceArray[1]) ? $priceArray[1] : ''); ?>"
                                >
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <label class="col-sm-3 col-form-label">Prices for <?php echo e(isset($sizeArray[2]) ? $sizeArray[2] : ''); ?></label>
                            <div class="col-sm-9">
                                <input type="text"
                                       class="form-control"
                                       name="priceL"
                                       placeholder="Price"
                                       value="<?php echo e(isset($priceArray[2]) ? $priceArray[2] : ''); ?>"
                                >
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <label class="col-sm-3 col-form-label">Prices for <?php echo e(isset($sizeArray[3]) ? $sizeArray[3] : ''); ?></label>
                            <div class="col-sm-9">
                                <input
                                    type="text"
                                    class="form-control"
                                    name="priceXL"
                                    placeholder="Price"
                                    value="<?php echo e(isset($priceArray[3]) ? $priceArray[3] : ''); ?>"
                                >
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <label class="col-sm-3 col-form-label">Sizes</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" value="<?php echo e($data['size']); ?>" name="size" placeholder="">
                            </div>
                        </div>

                        <div class="mb-3 row">
                            <label class="col-sm-3 col-form-label">Image</label>
                            <div class="col-sm-9">
                                <input type="file" class="form-control" name="image" placeholder="Image of the Item">
                            </div>
                        </div>
                    </form>
                </div>
                <button type="button"  class="btn btn-primary updateItem col-xl-3 mx-auto">Update changes</button>
            </div>

        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script !src="">
        //this is to add a new Item
        $(document).on('click', '.updateItem', function(e){
            var data = new FormData($('#updateForm')[0]);
            data.append('id', "<?php echo e($data['id']); ?>");
            $.ajax({
                url: "<?php echo e(route('admin.updateItem')); ?>",
                type: "POST",
                dataType: "JSON",
                data: data,
                cache: false,
                async: false,
                processData: false,
                contentType: false,
                success: function (data) {
                    if (data.status == 1) {
                        Swal.fire({
                            title: 'Success',
                            text: data.message,
                            type: 'success',
                            timer: 2000,
                            showCancelButton: false,
                            showConfirmButton: false
                        });
                        // $("#loginForm").trigger('reset');
                        window.location.href = "<?php echo e(route('admin.items')); ?>";
                    } else {
                        Swal.fire({
                            title: 'Failed',
                            text: data.message,
                            type: 'error',
                            timer: 2000,
                            showCancelButton: false,
                            showConfirmButton: false
                        })
                    }
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\PizzaOnlineV-2\resources\views/admin/product/product_update.blade.php ENDPATH**/ ?>